/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class Mercator
extends MapProjection {
    private static final long serialVersionUID = 6146741819833248649L;
    private static final double EPSILON = 1.0E-6;
    protected final double standardParallel;

    protected Mercator(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(MapProjection.AbstractProvider.STANDARD_PARALLEL_1)) {
            this.standardParallel = Math.abs(this.doubleValue(expected, MapProjection.AbstractProvider.STANDARD_PARALLEL_1, parameters));
            Mercator.ensureLatitudeInRange(MapProjection.AbstractProvider.STANDARD_PARALLEL_1, this.standardParallel, false);
            this.scaleFactor = this.isSpherical ? (this.scaleFactor *= Math.cos(this.standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(this.standardParallel), Math.cos(this.standardParallel)));
            this.globalScale = this.scaleFactor * this.semiMajor;
        } else {
            this.standardParallel = Double.NaN;
        }
        double sinPhi = Math.sin(this.latitudeOfOrigin);
        this.globalScale *= Math.cos(this.latitudeOfOrigin) / Math.sqrt(1.0 - this.excentricitySquared * sinPhi * sinPhi);
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            this.set(expected, MapProjection.AbstractProvider.STANDARD_PARALLEL_1, values, this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y) > 1.5707953267948966) {
            throw new ProjectionException(y);
        }
        y = -Math.log(this.tsfn(y, Math.sin(y)));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        y = Math.exp(-y);
        y = this.cphi2(y);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Mercator that = (Mercator)object;
            return Mercator.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    static abstract class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.ensureSpherical();
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (Math.abs(y) > 1.5707953267948966) {
                throw new ProjectionException(y);
            }
            assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
            y = Math.log(Math.tan(0.7853981633974483 + 0.5 * y));
            assert (Spherical.checkTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
            assert (Spherical.checkInverseTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }
}

