/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.referencing.operation.projection.StereographicUSGS;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class ObliqueStereographic
extends StereographicUSGS {
    private static final long serialVersionUID = -1454098847621943639L;
    private static final double ITERATION_TOLERANCE = 1.0E-14;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double EPSILON = 1.0E-6;
    private final double C;
    private final double K;
    private final double ratexp;
    private final double phic0;
    private final double cosc0;
    private final double sinc0;
    private final double R2;

    protected ObliqueStereographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, Provider.PARAMETERS);
    }

    ObliqueStereographic(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
        super(parameters, descriptor);
        double sphi = Math.sin(this.latitudeOfOrigin);
        double cphi = Math.cos(this.latitudeOfOrigin);
        cphi *= cphi;
        this.R2 = 2.0 * Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * sphi * sphi);
        this.C = Math.sqrt(1.0 + this.excentricitySquared * cphi * cphi / (1.0 - this.excentricitySquared));
        this.phic0 = Math.asin(sphi / this.C);
        this.sinc0 = Math.sin(this.phic0);
        this.cosc0 = Math.cos(this.phic0);
        this.ratexp = 0.5 * this.C * this.excentricity;
        this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.latitudeOfOrigin + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * sphi, this.ratexp));
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
        y = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * y + 0.7853981633974483), this.C) * ObliqueStereographic.srat(this.excentricity * Math.sin(y), this.ratexp)) - 1.5707963267948966;
        double sinc = Math.sin(y);
        double cosc = Math.cos(y);
        double cosl = Math.cos(x *= this.C);
        double k = this.R2 / (1.0 + this.sinc0 * sinc + this.cosc0 * cosc * cosl);
        x = k * cosc * Math.sin(x);
        y = k * (this.cosc0 * sinc - this.sinc0 * cosc * cosl);
        assert (ObliqueStereographic.checkTransform(x, y, ptDst, 0.1));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
        double rho = Math.hypot(x, y);
        if (Math.abs(rho) < 1.0E-6) {
            x = 0.0;
            y = this.phic0;
        } else {
            double ce = 2.0 * Math.atan2(rho, this.R2);
            double sinc = Math.sin(ce);
            double cosc = Math.cos(ce);
            x = Math.atan2(x * sinc, rho * this.cosc0 * cosc - y * this.sinc0 * sinc);
            y = Math.abs(y = cosc * this.sinc0 + y * sinc * this.cosc0 / rho) >= 1.0 ? (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(y);
        }
        x /= this.C;
        double num = Math.pow(Math.tan(0.5 * y + 0.7853981633974483) / this.K, 1.0 / this.C);
        int i = 15;
        while (!(Math.abs((phi = 2.0 * Math.atan(num * ObliqueStereographic.srat(this.excentricity * Math.sin(y), -0.5 * this.excentricity)) - 1.5707963267948966) - y) < 1.0E-14)) {
            y = phi;
            if (--i >= 0) continue;
            throw new ProjectionException(95);
        }
        assert (ObliqueStereographic.checkInverseTransform(x, y, ptDst, 0.01));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    private static double srat(double esinp, double exp) {
        return Math.pow((1.0 - esinp) / (1.0 + esinp), exp);
    }

    public static final class Provider
    extends Stereographic.Provider {
        private static final long serialVersionUID = 6505988910141381354L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Oblique_Stereographic"), new NamedIdentifier(Citations.EPSG, "Oblique Stereographic"), new NamedIdentifier(Citations.EPSG, "Roussilhe"), new NamedIdentifier(Citations.EPSG, "9809"), new NamedIdentifier(Citations.GEOTIFF, "CT_ObliqueStereographic"), new NamedIdentifier(Citations.ESRI, "Double_Stereographic"), new NamedIdentifier(Citations.GEOTOOLS, NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        MathTransform createMathTransform(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor) throws ParameterNotFoundException {
            return new ObliqueStereographic(parameters, descriptor);
        }
    }
}

