/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExternalGraphicTest
extends TestCase {
    private static final long TIME = 3000L;
    SimpleFeatureSource pointFS;
    SimpleFeatureSource lineFS;
    ReferencedEnvelope bounds;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.pointFS = ds.getFeatureSource("point");
        this.lineFS = ds.getFeatureSource("line");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public void testExternalGraphic() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle((Object)this, "externalGraphic.sld");
        Style lStyle = RendererBaseTest.loadStyle((Object)this, "lineGray.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.lineFS, lStyle);
        mc.addLayer((FeatureSource)this.pointFS, pStyle);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("Decorative marks", (GTRenderer)renderer, 3000L, this.bounds);
    }
}

