/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;

public class StyleAttributeExtractorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    StyleBuilder sb = new StyleBuilder(this.ff);

    @Test
    public void testPlainFilter() {
        PropertyIsGreaterThan f = this.ff.greater((Expression)this.ff.property("attribute"), (Expression)this.ff.literal(10));
        Rule r = this.sb.createRule((Symbolizer)this.sb.createPointSymbolizer());
        r.setFilter((Filter)f);
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertTrue((boolean)atts.contains("attribute"));
        Assert.assertEquals((long)1L, (long)atts.size());
        Assert.assertTrue((boolean)extractor.getDefaultGeometryUsed());
    }

    public void testGeometryTransformation() {
        PointSymbolizer ps = this.sb.createPointSymbolizer();
        ps.setGeometry((Expression)this.ff.function("offset", new Expression[]{this.ff.property("the_geom"), this.ff.property("offx"), this.ff.property("offy")}));
        Rule r = this.sb.createRule((Symbolizer)ps);
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertEquals((long)3L, (long)atts.size());
        Assert.assertTrue((boolean)atts.contains("the_geom"));
        Assert.assertTrue((boolean)atts.contains("offx"));
        Assert.assertTrue((boolean)atts.contains("offy"));
        Assert.assertFalse((boolean)extractor.getDefaultGeometryUsed());
    }
}

