/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.geotools.data.ServiceInfo;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.feature.FeatureTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapefileURLServiceInfo
implements ServiceInfo {
    private final ShapefileDataStore shapefile;

    ShapefileURLServiceInfo(ShapefileDataStore shapefile) {
        this.shapefile = shapefile;
    }

    public URI getSchema() {
        return FeatureTypes.DEFAULT_NAMESPACE;
    }

    public Icon getIcon() {
        return null;
    }

    public URI getPublisher() {
        return null;
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.shapefile.getCurrentTypeName());
        buf.append(" non local shapefile.");
        return buf.toString();
    }

    public String getTitle() {
        return this.shapefile.getCurrentTypeName();
    }

    public URI getSource() {
        String url = this.shapefile.shpFiles.get(ShpFileType.SHP);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Set<String> getKeywords() {
        IndexedShapefileDataStore indexed;
        HashSet<String> words = new HashSet<String>();
        words.add(this.shapefile.getCurrentTypeName());
        words.add("shp");
        words.add("dbf");
        words.add("shx");
        if (this.shapefile instanceof IndexedShapefileDataStore && (indexed = (IndexedShapefileDataStore)this.shapefile).indexUseable(ShpFileType.QIX)) {
            words.add("qix");
        }
        words.add("shapefile");
        return words;
    }
}

