/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.CloseableIteratorWrapper;
import org.geotools.data.shapefile.indexed.FidIndexer;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileAttributeReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileFeatureWriter;
import org.geotools.data.shapefile.indexed.ShapeFIDReader;
import org.geotools.data.shapefile.indexed.ShapeFileIndexer;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.IdCollectorFilterVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.index.CachedQuadTree;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.renderer.ScreenMap;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedShapefileDataStore
extends ShapefileDataStore
implements FileWriter {
    IndexType treeType;
    final boolean useIndex;
    final boolean createIndex;
    CachedQuadTree cachedTree;
    int maxQixCacheSize = DEFAULT_MAX_QIX_CACHE_SIZE;
    static final int DEFAULT_MAX_QIX_CACHE_SIZE;

    public IndexedShapefileDataStore(URL url) throws MalformedURLException {
        this(url, null, false, true, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, URI namespace) throws MalformedURLException {
        this(url, namespace, false, true, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, boolean useMemoryMappedBuffer, boolean createIndex) throws MalformedURLException {
        this(url, null, useMemoryMappedBuffer, createIndex, IndexType.QIX);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean createIndex, IndexType treeType) throws MalformedURLException {
        this(url, namespace, useMemoryMappedBuffer, createIndex, treeType, DEFAULT_STRING_CHARSET);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean createIndex, IndexType treeType, Charset dbfCharset) throws MalformedURLException {
        super(url, namespace, useMemoryMappedBuffer, dbfCharset);
        this.treeType = treeType;
        this.useIndex = treeType != IndexType.NONE;
        this.createIndex = createIndex;
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean cacheMemoryMaps, boolean createIndex, IndexType treeType, Charset dbfCharset) throws MalformedURLException {
        super(url, namespace, useMemoryMappedBuffer, cacheMemoryMaps, dbfCharset);
        this.treeType = treeType;
        this.useIndex = treeType != IndexType.NONE;
        this.createIndex = createIndex;
    }

    public boolean createSpatialIndex(boolean force) {
        try {
            if (this.shpFiles.isLocal() && this.createIndex && (this.needsGeneration(this.treeType.shpFileType) || force)) {
                this.createSpatialIndex();
                return true;
            }
        }
        catch (IOException e) {
            this.treeType = IndexType.NONE;
            ShapefileDataStoreFactory.LOGGER.log(Level.SEVERE, e.getLocalizedMessage());
        }
        return false;
    }

    public void createSpatialIndex() throws IOException {
        this.buildQuadTree();
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        if (filter instanceof Id && this.isLocal() && this.shpFiles.exists(ShpFileType.FIX)) {
            return Filter.INCLUDE;
        }
        return filter;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            return super.getFeatureWriterAppend(typeName, transaction);
        }
        FeatureWriter writer = this.state(transaction).writer(typeName, (Filter)Filter.EXCLUDE);
        if (this.getLockingManager() != null) {
            writer = ((InProcessLockingManager)this.getLockingManager()).checkedWriter(writer, transaction);
        }
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                state = new TransactionStateDiff((AbstractDataStore)this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        String[] propertyNames = query.getPropertyNames() == null ? new String[]{} : query.getPropertyNames();
        String defaultGeomName = this.schema.getGeometryDescriptor().getLocalName();
        if (propertyNames.length > 0) {
            FilterAttributeExtractor fae = new FilterAttributeExtractor(this.schema);
            query.getFilter().accept((FilterVisitor)fae, null);
            LinkedHashSet<String> attributes = new LinkedHashSet<String>(Arrays.asList(propertyNames));
            attributes.addAll(fae.getAttributeNameSet());
            propertyNames = attributes.toArray(new String[attributes.size()]);
        }
        SimpleFeatureType newSchema = this.schema;
        boolean readDbf = true;
        boolean readGeometry = true;
        try {
            if (query.getPropertyNames() != Query.NO_NAMES && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName)) {
                readDbf = false;
                newSchema = this.createSubType(propertyNames);
            } else if (query.getPropertyNames() == Query.NO_NAMES && propertyNames.length == 0) {
                readDbf = false;
                readGeometry = false;
                newSchema = this.createSubType(propertyNames);
            } else if (propertyNames.length > 0 && !propertyNames[0].equals(defaultGeomName)) {
                readGeometry = false;
                newSchema = this.createSubType(propertyNames);
            } else if (propertyNames.length > 0) {
                newSchema = this.createSubType(propertyNames);
            }
            return this.createFeatureReader(typeName, this.getAttributesReader(readDbf, readGeometry, query, newSchema), newSchema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", (Throwable)se);
        }
    }

    public SimpleFeatureType createSubType(String[] properties) throws SchemaException {
        if (properties == null || properties.length == 0) {
            return this.schema;
        }
        boolean same = this.schema.getAttributeCount() == properties.length;
        for (int i = 0; i < this.schema.getAttributeCount() && same; ++i) {
            same = this.schema.getDescriptor(i).getLocalName().equals(properties[i]);
        }
        if (same) {
            return this.schema;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(this.schema.getName());
        HashSet<String> propIndex = new HashSet<String>(Arrays.asList(properties));
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            if (!propIndex.contains(ad.getLocalName())) continue;
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(String typeName, IndexedShapefileAttributeReader r, SimpleFeatureType readerSchema) throws SchemaException, IOException {
        if (r == null) {
            return new EmptyFeatureReader((FeatureType)readerSchema);
        }
        Object fidReader = !this.indexUseable(ShpFileType.FIX) ? new ShapeFIDReader(this.getCurrentTypeName(), (ShapefileAttributeReader)r) : new IndexedFidReader(this.shpFiles, r);
        return new FIDFeatureReader((AttributeReader)r, (FIDReader)fidReader, readerSchema);
    }

    public void generateFidIndex() throws IOException {
        FidIndexer.generate(this.shpFiles);
    }

    boolean existsOrCreateFidIndex() {
        if (this.indexUseable(ShpFileType.FIX)) {
            return true;
        }
        if (this.isLocal()) {
            try {
                FidIndexer.generate(this.shpFiles);
                return true;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to create fid index");
                return false;
            }
        }
        return false;
    }

    protected IndexedShapefileAttributeReader getAttributesReader(boolean readDbf, boolean readGeometry, Query query, SimpleFeatureType targetSchema) throws IOException {
        ReferencedEnvelope bbox = new ReferencedEnvelope();
        Filter filter = query != null ? query.getFilter() : null;
        CloseableIterator<Data> goodRecs = null;
        if (filter instanceof Id && this.shpFiles.isLocal() && this.existsOrCreateFidIndex()) {
            Id fidFilter = (Id)filter;
            TreeSet<Identifier> idsSet = new TreeSet<Identifier>(new IdentifierComparator());
            idsSet.addAll(fidFilter.getIdentifiers());
            List<Data> records = this.queryFidIndex(idsSet);
            if (records != null) {
                goodRecs = new CloseableIteratorWrapper<Data>(records.iterator());
            }
        } else {
            if (filter != null && (bbox = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)bbox)) == null) {
                bbox = new ReferencedEnvelope();
            }
            if (!bbox.isNull() && this.useIndex) {
                try {
                    goodRecs = this.queryQuadTree((Envelope)bbox);
                }
                catch (TreeException e) {
                    throw new IOException("Error querying index: " + e.getMessage());
                }
            }
        }
        ArrayList<AttributeDescriptor> atts = targetSchema.getAttributeDescriptors();
        IndexedDbaseFileReader dbfR = null;
        if (goodRecs != null && !goodRecs.hasNext()) {
            goodRecs.close();
            return null;
        }
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new ArrayList<AttributeDescriptor>(1);
            atts.add((AttributeDescriptor)this.schema.getGeometryDescriptor());
            if (!readGeometry) {
                atts = new ArrayList(1);
            }
        } else {
            dbfR = (IndexedDbaseFileReader)this.openDbfReader();
        }
        Hints hints = query != null ? query.getHints() : null;
        ShapefileReader shapeReader = this.openShapeReader(this.getGeometryFactory(hints), goodRecs != null);
        IndexedShapefileAttributeReader reader = new IndexedShapefileAttributeReader(atts, shapeReader, dbfR, goodRecs);
        reader.setTargetBBox((Envelope)bbox);
        if (hints != null) {
            Number simplificationDistance = (Number)hints.get((Object)Hints.GEOMETRY_DISTANCE);
            if (simplificationDistance != null) {
                reader.setSimplificationDistance(simplificationDistance.doubleValue());
            }
            reader.setScreenMap((ScreenMap)hints.get((Object)Hints.SCREENMAP));
            if (Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D))) {
                shapeReader.setFlatGeometry(true);
            }
        }
        return reader;
    }

    protected ShapefileReader openShapeReader(GeometryFactory gf, boolean onlyRandomAccess) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.useMemoryMappedBuffer, gf, onlyRandomAccess);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", (Throwable)((Object)se));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Data> queryFidIndex(Set<Identifier> idsSet) throws IOException {
        if (!this.indexUseable(ShpFileType.FIX)) {
            return null;
        }
        IndexedFidReader reader = new IndexedFidReader(this.shpFiles);
        ArrayList<Data> records = new ArrayList<Data>(idsSet.size());
        try {
            IndexFile shx = this.openIndexFile();
            try {
                DataDefinition def = new DataDefinition("US-ASCII");
                def.addField(Integer.class);
                def.addField(Long.class);
                for (Identifier identifier : idsSet) {
                    String fid = identifier.toString();
                    long recno = reader.findFid(fid);
                    if (recno == -1L) {
                        if (!LOGGER.isLoggable(Level.FINEST)) continue;
                        LOGGER.finest("fid " + fid + " not found in index, continuing with next queried fid...");
                        continue;
                    }
                    try {
                        Data data = new Data(def);
                        data.addValue(new Integer((int)recno + 1));
                        data.addValue(new Long(shx.getOffsetInBytes((int)recno)));
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("fid " + fid + " found for record #" + data.getValue(0) + " at index file offset " + data.getValue(1));
                        }
                        records.add(data);
                    }
                    catch (Exception e) {
                        IOException exception = new IOException();
                        exception.initCause(e);
                        throw exception;
                        return records;
                    }
                }
            }
            finally {
                shx.close();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexUseable(ShpFileType indexType) {
        if (this.isLocal()) {
            if (this.needsGeneration(indexType) || !this.shpFiles.exists(indexType)) {
                return false;
            }
        } else {
            ReadableByteChannel read = null;
            try {
                read = this.shpFiles.getReadChannel(indexType, this);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e) {
                        ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "could not close stream", e);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsGeneration(ShpFileType indexType) {
        if (indexType == null) {
            return false;
        }
        if (!this.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local and the file can be created");
        }
        URL indexURL = this.shpFiles.acquireRead(indexType, this);
        URL shpURL = this.shpFiles.acquireRead(ShpFileType.SHP, this);
        try {
            long shpLastModified;
            if (indexURL == null) {
                boolean bl = true;
                return bl;
            }
            if (!this.shpFiles.exists(ShpFileType.SHX) || !this.shpFiles.exists(ShpFileType.SHP)) {
                boolean bl = false;
                return bl;
            }
            File indexFile = DataUtilities.urlToFile((URL)indexURL);
            File shpFile = DataUtilities.urlToFile((URL)shpURL);
            long indexLastModified = indexFile.lastModified();
            boolean shpChangedMoreRecently = indexLastModified < (shpLastModified = shpFile.lastModified());
            boolean bl = !indexFile.exists() || shpChangedMoreRecently;
            return bl;
        }
        finally {
            if (shpURL != null) {
                this.shpFiles.unlockRead(shpURL, (FileReader)this);
            }
            if (indexURL != null) {
                this.shpFiles.unlockRead(indexURL, (FileReader)this);
            }
        }
    }

    public boolean isIndexed() {
        if (this.shpFiles.isLocal()) {
            return true;
        }
        return !this.needsGeneration(ShpFileType.FIX) && !this.needsGeneration(this.treeType.shpFileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIterator<Data> queryQuadTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        CloseableIterator<Data> tmp = null;
        this.createSpatialIndex(false);
        if (this.cachedTree == null) {
            QuadTree quadTree;
            boolean canCache = false;
            URL treeURL = this.shpFiles.acquireRead(ShpFileType.QIX, this);
            try {
                File treeFile = DataUtilities.urlToFile((URL)treeURL);
                if (treeFile.exists() && treeFile.length() < (long)(1024 * this.maxQixCacheSize)) {
                    canCache = true;
                }
            }
            finally {
                this.shpFiles.unlockRead(treeURL, (FileReader)this);
            }
            if (canCache && (quadTree = this.openQuadTree()) != null) {
                LOGGER.warning("Experimental: loading in memory the quadtree for " + this.shpFiles.get(ShpFileType.SHP));
                this.cachedTree = new CachedQuadTree(quadTree);
                quadTree.close();
            }
        }
        if (this.cachedTree != null) {
            if (!bbox.contains(this.cachedTree.getBounds())) {
                return this.cachedTree.search(bbox);
            }
            return null;
        }
        try {
            QuadTree quadTree = this.openQuadTree();
            if (quadTree != null && !bbox.contains(quadTree.getRoot().getBounds())) {
                tmp = quadTree.search(bbox);
            }
            if (tmp == null && quadTree != null) {
                quadTree.close();
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error querying QuadTree", (Throwable)e);
        }
        return tmp;
    }

    @Override
    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        return new IndexedDbaseFileReader(this.shpFiles, this.useMemoryMappedBuffer, this.dbfCharset, this.dbfTimeZone);
    }

    protected QuadTree openQuadTree() throws StoreException {
        if (!this.isLocal()) {
            return null;
        }
        URL treeURL = this.shpFiles.acquireRead(ShpFileType.QIX, this);
        try {
            File treeFile = DataUtilities.urlToFile((URL)treeURL);
            if (!treeFile.exists() || treeFile.length() == 0L) {
                this.treeType = IndexType.NONE;
                QuadTree quadTree = null;
                return quadTree;
            }
            FileSystemIndexStore store = new FileSystemIndexStore(treeFile);
            QuadTree quadTree = store.load(this.openIndexFile(), this.useMemoryMappedBuffer);
            return quadTree;
        }
        finally {
            this.shpFiles.unlockRead(treeURL, (FileReader)this);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        IndexedShapefileAttributeReader attReader;
        this.typeCheck(typeName);
        this.existsOrCreateFidIndex();
        try {
            SimpleFeatureType schema = this.getSchema();
            if (schema == null) {
                throw new IOException("To create a shapefile, you must first call createSchema()");
            }
            attReader = this.getAttributesReader(true, true, null, schema);
            featureReader = this.createFeatureReader(typeName, attReader, schema);
        }
        catch (Exception e) {
            attReader = this.getAttributesReader(true, true, null, this.schema);
            featureReader = new FeatureReader<SimpleFeatureType, SimpleFeature>((FeatureType)this.schema);
        }
        if (featureReader == null) {
            return new EmptyFeatureWriter(this.schema);
        }
        return new IndexedShapefileFeatureWriter(typeName, this.shpFiles, attReader, featureReader, this, this.dbfCharset, this.dbfTimeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        CoordinateSequenceFactory csFactory;
        List<Data> recordsFound;
        ReferencedEnvelope ret = null;
        HashSet<Data> records = new HashSet<Data>();
        Filter filter = query.getFilter();
        if (filter == Filter.INCLUDE || query == Query.ALL) {
            return this.getBounds();
        }
        IdentifierComparator identifierComparator = new IdentifierComparator();
        Set fids = (Set)filter.accept((FilterVisitor)IdCollectorFilterVisitor.IDENTIFIER_COLLECTOR, new TreeSet<Identifier>(identifierComparator));
        if (!fids.isEmpty() && (recordsFound = this.queryFidIndex(fids)) != null) {
            records.addAll(recordsFound);
        }
        if (records.isEmpty()) {
            return null;
        }
        Hints hints = query.getHints();
        GeometryFactory geometryFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null && (csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY)) != null) {
            geometryFactory = new GeometryFactory(csFactory);
        }
        if (geometryFactory == null) {
            geometryFactory = new GeometryFactory();
        }
        ShapefileReader reader = new ShapefileReader(this.shpFiles, false, false, geometryFactory);
        try {
            ret = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            for (Data data : records) {
                reader.goTo(((Long)data.getValue(1)).intValue());
                ShapefileReader.Record record = reader.nextRecord();
                ret.expandToInclude(new Envelope(record.minX, record.maxX, record.minY, record.maxY));
            }
            ReferencedEnvelope referencedEnvelope = ret;
            return referencedEnvelope;
        }
        finally {
            reader.close();
        }
    }

    public void buildQuadTree() throws TreeException {
        if (this.isLocal()) {
            LOGGER.fine("Creating spatial index for " + this.shpFiles.get(ShpFileType.SHP));
            ShapeFileIndexer indexer = new ShapeFileIndexer();
            indexer.setShapeFileName(this.shpFiles);
            try {
                indexer.index(false, (ProgressListener)new NullProgressListener());
            }
            catch (MalformedURLException e) {
                throw new TreeException(e);
            }
            catch (LockTimeoutException e) {
                throw new TreeException(e);
            }
            catch (Exception e) {
                if (e instanceof TreeException) {
                    throw (TreeException)e;
                }
                throw new TreeException(e);
            }
        }
    }

    public boolean isMemoryMapped() {
        return this.useMemoryMappedBuffer;
    }

    @Override
    public String id() {
        return this.getClass().getName() + ": " + this.getCurrentTypeName();
    }

    @Override
    protected Set getSupportedHints() {
        HashSet<Object> hints = new HashSet<Object>();
        hints.add(Hints.FEATURE_DETACHED);
        hints.add(Hints.JTS_GEOMETRY_FACTORY);
        hints.add(Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        hints.add(Hints.GEOMETRY_DISTANCE);
        hints.add(Hints.SCREENMAP);
        return hints;
    }

    static {
        int max = -1;
        try {
            String smax = System.getProperty("org.geotools.shapefile.maxQixCacheSize");
            if (smax != null) {
                max = Integer.parseInt(smax);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Could not set the max qix cache size", t);
        }
        DEFAULT_MAX_QIX_CACHE_SIZE = max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdentifierComparator
    implements Comparator<Identifier> {
        private IdentifierComparator() {
        }

        @Override
        public int compare(Identifier o1, Identifier o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

