/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.AttributeReader;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.renderer.ScreenMap;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapefileAttributeReader
extends AbstractAttributeIO
implements AttributeReader,
RecordNumberTracker {
    protected ShapefileReader shp;
    protected DbaseFileReader dbf;
    protected DbaseFileReader.Row row;
    protected ShapefileReader.Record record;
    int cnt;
    protected int[] dbfindexes;
    protected Envelope targetBBox;
    protected double simplificationDistance;
    protected Object geometry;
    protected ScreenMap screenMap;
    protected boolean featureAvailable = false;
    protected boolean flatFeature = false;

    public ShapefileAttributeReader(List<AttributeDescriptor> atts, ShapefileReader shp, DbaseFileReader dbf) {
        this(atts.toArray(new AttributeDescriptor[0]), shp, dbf);
    }

    public void setTargetBBox(Envelope envelope) {
        this.targetBBox = envelope;
    }

    public void setSimplificationDistance(double distance) {
        this.simplificationDistance = distance;
    }

    public void setScreenMap(ScreenMap screenMap) {
        this.screenMap = screenMap;
    }

    public ShapefileAttributeReader(AttributeDescriptor[] atts, ShapefileReader shp, DbaseFileReader dbf) {
        super(atts);
        this.shp = shp;
        this.dbf = dbf;
        if (dbf != null) {
            this.dbfindexes = new int[atts.length];
            DbaseFileHeader head = dbf.getHeader();
            block0: for (int i = 0; i < atts.length; ++i) {
                String attName = atts[i].getLocalName();
                int count = 0;
                if (atts[i].getUserData().get("original") != null) {
                    attName = (String)atts[i].getUserData().get("original");
                    count = (Integer)atts[i].getUserData().get("count");
                }
                for (int j = 0; j < head.getNumFields(); ++j) {
                    if (!head.getFieldName(j).equals(attName) || count-- > 0) continue;
                    this.dbfindexes[i] = j;
                    continue block0;
                }
                this.dbfindexes[i] = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.shp != null) {
                this.shp.close();
            }
            if (this.dbf != null) {
                this.dbf.close();
            }
        }
        finally {
            this.row = null;
            this.record = null;
            this.shp = null;
            this.dbf = null;
        }
    }

    boolean internalReadersHaveNext() throws IOException {
        int n;
        int n2 = n = this.shp.hasNext() ? 1 : 0;
        if (this.dbf != null) {
            n += this.dbf.hasNext() ? 2 : 0;
        }
        if (n == 3 || n == 1 && this.dbf == null) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
    }

    public boolean hasNext() throws IOException {
        while (!this.featureAvailable && this.internalReadersHaveNext()) {
            boolean skip;
            block12: {
                this.record = this.shp.nextRecord();
                Envelope envelope = this.record.envelope();
                skip = false;
                if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) {
                    this.geometry = null;
                    skip = true;
                } else if (this.simplificationDistance > 0.0 && envelope.getWidth() < this.simplificationDistance && envelope.getHeight() < this.simplificationDistance) {
                    try {
                        if (this.screenMap != null && this.screenMap.checkAndSet(envelope)) {
                            this.geometry = null;
                            skip = true;
                            break block12;
                        }
                        this.geometry = this.record.getSimplifiedShape(this.screenMap);
                    }
                    catch (Exception e) {
                        this.geometry = this.record.getSimplifiedShape();
                    }
                } else {
                    this.geometry = this.record.shape();
                }
            }
            if (this.dbf != null) {
                if (skip) {
                    this.dbf.skip();
                    this.row = null;
                } else {
                    this.row = this.dbf.readRow();
                }
            } else {
                this.row = null;
            }
            this.featureAvailable = !skip;
        }
        return this.featureAvailable;
    }

    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("hasNext() returned false");
        }
        this.featureAvailable = false;
    }

    public Object read(int param) throws IOException, ArrayIndexOutOfBoundsException {
        int index = this.dbfindexes != null ? this.dbfindexes[param] : -1;
        switch (index) {
            case -1: {
                return this.geometry;
            }
        }
        if (this.row != null) {
            return this.row.read(index);
        }
        return null;
    }

    @Override
    public int getRecordNumber() {
        return this.record.number;
    }
}

