/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JCRSChooser {
    public static CoordinateReferenceSystem showDialog(Component parent, String title, String message, String initialSelection) {
        CoordinateReferenceSystem crs = null;
        if (title == null) {
            title = "Choose Projection";
        }
        try {
            CRSAuthorityFactory authorityFactory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
            Set codes = authorityFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
            ArrayList<String> desc = new ArrayList<String>();
            for (String code : codes) {
                desc.add(code + ": " + authorityFactory.getDescriptionText("EPSG:" + code).toString());
            }
            String selected = (String)JOptionPane.showInputDialog(parent, message, title, 3, null, desc.toArray(), initialSelection);
            if (selected == null) {
                return null;
            }
            String selectedCode = selected.substring(0, selected.indexOf(58));
            crs = CRS.decode((String)("EPSG:" + selectedCode), (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return crs;
    }
}

