/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFileImageChooser
extends JFileChooser {
    private static final Set<FormatSpecifier> supportedReaders = new TreeSet<FormatSpecifier>();
    private static final Set<FormatSpecifier> supportedWriters = new TreeSet<FormatSpecifier>();

    public JFileImageChooser() {
        this((File)null);
    }

    public JFileImageChooser(File workingDir) {
        super(workingDir);
    }

    @Override
    public void approveSelection() {
        FormatFilter filter = (FormatFilter)this.getFileFilter();
        File file = this.getSelectedFile();
        String name = file.getAbsolutePath();
        int dot = name.lastIndexOf(46);
        boolean ok = true;
        if (dot < 0) {
            name = name + filter.getDefaultSuffix();
            file = new File(name);
            this.setSelectedFile(file);
        }
        if (this.getDialogType() == 1) {
            if (!filter.accept(this.getSelectedFile())) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(name.substring(dot + 1));
                sb.append("' ");
                sb.append("is not a standard suffix for a ");
                sb.append(filter.getDescription());
                sb.append(".");
                sb.append("\nDo you want to save with this name ?");
                int answer = JOptionPane.showConfirmDialog(this.getParent(), sb.toString(), "Incompatible file suffix", 0);
                boolean bl = ok = answer == 0;
            }
            if (ok && file.exists()) {
                int answer = JOptionPane.showConfirmDialog(this, "Overwrite the existing file ?", "File exists", 0);
                ok = answer == 0;
            }
        } else if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "Can't file this file", "File not found", 2);
            ok = false;
        }
        if (ok) {
            super.approveSelection();
        }
    }

    private void setFilter(Set<FormatSpecifier> supportedFormats) {
        this.setAcceptAllFileFilterUsed(false);
        for (FormatSpecifier format : supportedFormats) {
            this.addChoosableFileFilter(new FormatFilter(format));
        }
    }

    public static File showSaveFile(Component parent) {
        return JFileImageChooser.showSaveFile(parent, null);
    }

    public static File showSaveFile(Component parent, File workingDir) {
        JFileImageChooser chooser = new JFileImageChooser(workingDir);
        chooser.setFilter(supportedWriters);
        chooser.setDialogTitle("Save image");
        File file = null;
        if (chooser.showSaveDialog(parent) == 0) {
            file = chooser.getSelectedFile();
            String name = file.getAbsolutePath();
            int dot = name.lastIndexOf(46);
            FormatFilter filter = (FormatFilter)chooser.getFileFilter();
            if (dot < 0) {
                name = name + filter.getDefaultSuffix();
                file = new File(name);
            }
        }
        return file;
    }

    public static File showOpenFile(Component parent) {
        return JFileImageChooser.showOpenFile(parent, null);
    }

    public static File showOpenFile(Component parent, File workingDir) {
        JFileImageChooser chooser = new JFileImageChooser(workingDir);
        chooser.setFilter(supportedReaders);
        chooser.setDialogTitle("Open image file");
        File file = null;
        if (chooser.showOpenDialog(parent) == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    static {
        for (FormatSpecifier format : FormatSpecifier.values()) {
            if (ImageIO.getImageReadersBySuffix(format.id).hasNext()) {
                supportedReaders.add(format);
            }
            if (!ImageIO.getImageWritersBySuffix(format.id).hasNext()) continue;
            supportedWriters.add(format);
        }
    }

    private static class FormatFilter
    extends FileFilter {
        private FormatSpecifier format;

        FormatFilter(FormatSpecifier format) {
            this.format = format;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            for (String suffix : this.format.suffixes) {
                if (!f.getPath().endsWith(suffix) && !f.getPath().endsWith(suffix.toUpperCase())) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.format.desc;
        }

        public String getDefaultSuffix() {
            return this.format.suffixes[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FormatSpecifier {
        BMP("bmp", "BMP image", ".bmp"),
        GIF("gif", "GIF image", ".gif"),
        JPG("jpg", "JPEG image", ".jpg", ".jpeg"),
        PNG("png", "PNG image", "png"),
        TIF("tif", "TIFF image", ".tif", ".tiff");

        private String id;
        private String desc;
        private String[] suffixes;

        private FormatSpecifier(String id, String desc, String ... suffixes) {
            this.id = id;
            this.desc = desc;
            this.suffixes = new String[suffixes.length];
            for (int i = 0; i < suffixes.length; ++i) {
                this.suffixes[i] = suffixes[i];
            }
        }
    }
}

