/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.swing.ExceptionMonitor;
import org.geotools.swing.JCRSChooser;
import org.geotools.swing.JMapPane;
import org.geotools.swing.JTextReporter;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSPopupMenu
extends JPopupMenu {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    private JMapPane mapPane;

    public CRSPopupMenu() {
        this((JMapPane)null);
    }

    public CRSPopupMenu(JMapPane mapPane) {
        super("CRS options");
        this.mapPane = mapPane;
        JMenuItem setCRSItem = new JMenuItem(stringRes.getString("crs_popupmenu_setcrs"));
        setCRSItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CRSPopupMenu.this.setCRS();
            }
        });
        this.add(setCRSItem);
        JMenuItem showCRSItem = new JMenuItem(stringRes.getString("crs_popupmenu_showcrs"));
        showCRSItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CRSPopupMenu.this.showCRS();
            }
        });
        this.add(showCRSItem);
    }

    public void setMapPane(JMapPane mapPane) {
        this.mapPane = mapPane;
    }

    public void show(Component invoker, int x, int y) {
        boolean enabled = this.mapPane != null && this.mapPane.getMapContext() != null;
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            c.setEnabled(enabled);
        }
        super.show(invoker, x, y);
    }

    private void setCRS() {
        if (this.mapPane != null && this.mapPane.getMapContext() != null) {
            CoordinateReferenceSystem crs = this.mapPane.getMapContext().getCoordinateReferenceSystem();
            String initialSelection = null;
            try {
                if (crs != null) {
                    initialSelection = CRS.lookupIdentifier((Citation)Citations.EPSG, (CoordinateReferenceSystem)crs, (boolean)false);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            CoordinateReferenceSystem newCRS = JCRSChooser.showDialog(this.mapPane, null, "Choose a projection for the map display", initialSelection);
            if (!(newCRS == null || crs != null && CRS.equalsIgnoreMetadata((Object)crs, (Object)newCRS))) {
                try {
                    this.mapPane.getMapContext().setCoordinateReferenceSystem(newCRS);
                }
                catch (Exception ex) {
                    ExceptionMonitor.show(this, ex, "Failed to set the display CRS");
                }
            }
        }
    }

    private void showCRS() {
        if (this.mapPane != null && this.mapPane.getMapContext() != null) {
            CoordinateReferenceSystem crs = this.mapPane.getMapContext().getCoordinateReferenceSystem();
            String wkt = crs.toWKT();
            JTextReporter reporter = new JTextReporter("Coordinate reference system");
            reporter.append(wkt);
            reporter.setModal(true);
            reporter.setVisible(true);
        }
    }
}

