/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ReaderUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");

    private ReaderUtils() {
    }

    public static Element loadConfig(Reader configFile) throws IOException, ParserConfigurationException, SAXException {
        LOGGER.finest("loading configuration file " + configFile);
        InputSource in = new InputSource(configFile);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        dfactory.setIgnoringComments(true);
        dfactory.setCoalescing(true);
        dfactory.setIgnoringElementContentWhitespace(true);
        Document serviceDoc = dfactory.newDocumentBuilder().parse(in);
        Element configElem = serviceDoc.getDocumentElement();
        return configElem;
    }

    public static File initFile(File f, boolean isDir) throws IOException {
        if (!f.exists()) {
            throw new IOException("Path specified does not have a valid file.\n" + f + "\n\n");
        }
        if (isDir && !f.isDirectory()) {
            throw new IOException("Path specified does not have a valid file.\n" + f + "\n\n");
        }
        if (!isDir && !f.isFile()) {
            throw new IOException("Path specified does not have a valid file.\n" + f + "\n\n");
        }
        LOGGER.fine("File is valid: " + f);
        return f;
    }

    public static Element getChildElement(Element root, String name, boolean mandatory) throws SAXException {
        Node child;
        for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        if (mandatory && child == null) {
            throw new SAXException(root.getNodeName() + " does not contains a child element named " + name);
        }
        return null;
    }

    public static Element getChildElement(Element root, String name) {
        try {
            return ReaderUtils.getChildElement(root, name, false);
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static int getIntAttribute(Element elem, String attName, boolean mandatory, int defaultValue) throws SAXException {
        String attValue = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (!mandatory && attValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attValue);
        }
        catch (Exception ex) {
            if (mandatory) {
                throw new SAXException(attName + " attribute of element " + elem.getNodeName() + " must be an integer, but it's '" + attValue + "'");
            }
            return defaultValue;
        }
    }

    public static String getAttribute(Element elem, String attName, boolean mandatory) throws SAXException {
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new SAXException("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new SAXException("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    public static boolean getBooleanAttribute(Element elem, String attName, boolean mandatory) throws SAXException {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        return Boolean.valueOf(value);
    }

    public static String getChildText(Element root, String childName) {
        try {
            return ReaderUtils.getChildText(root, childName, false);
        }
        catch (SAXException ex) {
            return null;
        }
    }

    public static String getChildText(Element root, String childName, boolean mandatory) throws SAXException {
        Element elem = ReaderUtils.getChildElement(root, childName, mandatory);
        if (elem != null) {
            return ReaderUtils.getElementText(elem, mandatory);
        }
        if (mandatory) {
            String msg = "Mandatory child " + childName + "not found in " + " element: " + root;
            throw new SAXException(msg);
        }
        return null;
    }

    public static String getElementText(Element elem) {
        try {
            return ReaderUtils.getElementText(elem, false);
        }
        catch (SAXException ex) {
            return null;
        }
    }

    public static String getElementText(Element elem, boolean mandatory) throws SAXException {
        String value = null;
        LOGGER.finest("getting element text for " + elem);
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int nChilds = childs.getLength();
            for (int i = 0; i < nChilds; ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 3) continue;
                value = child.getNodeValue();
                if (!mandatory || !"".equals(value.trim())) break;
                throw new SAXException(elem.getNodeName() + " text is empty");
            }
            if (mandatory && value == null) {
                throw new SAXException(elem.getNodeName() + " element does not contains text");
            }
        } else {
            throw new SAXException("Argument element can't be null");
        }
        return value;
    }

    public static String[] getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        ArrayList<String> keywords = new ArrayList<String>(kCount);
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText(kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        Object[] s = keywords.toArray();
        if (s == null) {
            return new String[0];
        }
        String[] ss = new String[s.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = s[i].toString();
        }
        return ss;
    }

    public static Element getFirstChildElement(Element root) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static double getDoubleAttribute(Element elem, String attName, boolean mandatory) throws SAXException {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        double d = Double.NaN;
        if (value != null) {
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                throw new SAXException("Illegal attribute value for " + attName + " in element " + elem.getNodeName() + ". Expected double, but was " + value);
            }
        }
        return d;
    }
}

