/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.geotools.util.logging.Logging;

public class SchemaCatalog {
    private static final Logger LOGGER = Logging.getLogger((String)SchemaCatalog.class.getPackage().getName());
    private final Catalog catalog;

    private SchemaCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveLocation(String location) {
        String resolvedLocation = null;
        try {
            resolvedLocation = this.catalog.resolveURI(location);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (resolvedLocation != null) {
            InputStream input = null;
            try {
                input = new URL(resolvedLocation).openStream();
                LOGGER.fine("Catalog resolved " + location + " to " + resolvedLocation);
            }
            catch (IOException e) {
                LOGGER.fine("Catalog did not resolve " + location + " to " + resolvedLocation + " despite matching catalog entry because an error occurred: " + e.getMessage());
                resolvedLocation = null;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return resolvedLocation;
    }

    static Catalog buildPrivateCatalog(URL catalogLocation) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setVerbosity(0);
        catalogManager.setIgnoreMissingProperties(true);
        Catalog catalog = catalogManager.getCatalog();
        try {
            catalog.parseCatalog(catalogLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to load OASIS catalog from URL " + catalogLocation.toString(), e);
        }
        return catalog;
    }

    public static SchemaCatalog build(URL catalogLocation) {
        return new SchemaCatalog(SchemaCatalog.buildPrivateCatalog(catalogLocation));
    }
}

