/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.opengis.ows11.validation;

import net.opengis.ows11.AbstractReferenceBaseType;
import net.opengis.ows11.AllowedValuesType;
import net.opengis.ows11.AnyValueType;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.ContactType;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DatasetDescriptionSummaryBaseType;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.ExceptionType;
import net.opengis.ows11.GetCapabilitiesType;
import net.opengis.ows11.GetResourceByIdType;
import net.opengis.ows11.HTTPType;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.ManifestType;
import net.opengis.ows11.MetadataType;
import net.opengis.ows11.NoValuesType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.RangeClosureType;
import net.opengis.ows11.RangeType;
import net.opengis.ows11.ReferenceGroupType;
import net.opengis.ows11.ReferenceType;
import net.opengis.ows11.ResponsiblePartyType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.ows11.ServiceReferenceType;
import net.opengis.ows11.ValueType;
import net.opengis.ows11.ValuesReferenceType;
import net.opengis.ows11.WGS84BoundingBoxType;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * A sample validator interface for {@link net.opengis.ows11.DocumentRoot}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface DocumentRootValidator {
    boolean validate();

    boolean validateMixed(FeatureMap value);
    boolean validateXMLNSPrefixMap(EMap value);
    boolean validateXSISchemaLocation(EMap value);
    boolean validateAbstract(LanguageStringType value);
    boolean validateAbstractMetaData(EObject value);
    boolean validateAbstractReferenceBase(AbstractReferenceBaseType value);
    boolean validateAccessConstraints(String value);
    boolean validateAllowedValues(AllowedValuesType value);
    boolean validateAnyValue(AnyValueType value);
    boolean validateAvailableCRS(String value);
    boolean validateBoundingBox(BoundingBoxType value);
    boolean validateContactInfo(ContactType value);
    boolean validateDatasetDescriptionSummary(DatasetDescriptionSummaryBaseType value);
    boolean validateDataType(DomainMetadataType value);
    boolean validateDCP(DCPType value);
    boolean validateDefaultValue(ValueType value);
    boolean validateException(ExceptionType value);
    boolean validateExceptionReport(ExceptionReportType value);
    boolean validateExtendedCapabilities(EObject value);
    boolean validateFees(String value);
    boolean validateGetCapabilities(GetCapabilitiesType value);
    boolean validateGetResourceByID(GetResourceByIdType value);
    boolean validateHTTP(HTTPType value);
    boolean validateIdentifier(CodeType value);
    boolean validateIndividualName(String value);
    boolean validateInputData(ManifestType value);
    boolean validateKeywords(KeywordsType value);
    boolean validateLanguage(String value);
    boolean validateManifest(ManifestType value);
    boolean validateMaximumValue(ValueType value);
    boolean validateMeaning(DomainMetadataType value);
    boolean validateMetadata(MetadataType value);
    boolean validateMinimumValue(ValueType value);
    boolean validateNoValues(NoValuesType value);
    boolean validateOperation(OperationType value);
    boolean validateOperationResponse(ManifestType value);
    boolean validateOperationsMetadata(OperationsMetadataType value);
    boolean validateOrganisationName(String value);
    boolean validateOtherSource(MetadataType value);
    boolean validateOutputFormat(String value);
    boolean validatePointOfContact(ResponsiblePartyType value);
    boolean validatePositionName(String value);
    boolean validateRange(RangeType value);
    boolean validateReference(ReferenceType value);
    boolean validateReferenceGroup(ReferenceGroupType value);
    boolean validateReferenceSystem(DomainMetadataType value);
    boolean validateResource(EObject value);
    boolean validateRole(CodeType value);
    boolean validateServiceIdentification(ServiceIdentificationType value);
    boolean validateServiceProvider(ServiceProviderType value);
    boolean validateServiceReference(ServiceReferenceType value);
    boolean validateSpacing(ValueType value);
    boolean validateSupportedCRS(String value);
    boolean validateTitle(LanguageStringType value);
    boolean validateUOM(DomainMetadataType value);
    boolean validateValue(ValueType value);
    boolean validateValuesReference(ValuesReferenceType value);
    boolean validateWGS84BoundingBox(WGS84BoundingBoxType value);
    boolean validateRangeClosure(RangeClosureType value);
    boolean validateReference1(String value);
}
