/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;

public final class MapProxyTool {
    private MapProxyTool() {
    }

    public static Object newInstanceOfBeanProxyForMap(String className, Map<String, Object> map, Set<PropertyData> propertyDatas, ClassLoaderService classLoaderService) {
        Map<String, Class<?>> properties = MapProxyTool.prepareProperties(propertyDatas);
        return MapProxyTool.createNewInstance(map, MapProxyTool.classForName(className, properties, classLoaderService));
    }

    private static Object createNewInstance(Map<String, Object> map, Class aClass) {
        try {
            return aClass.getConstructor(Map.class).newInstance(map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Class<?>> prepareProperties(Set<PropertyData> propertyDatas) {
        HashMap properties = new HashMap();
        for (PropertyData propertyData : propertyDatas) {
            properties.put(propertyData.getBeanName(), Object.class);
        }
        return properties;
    }

    private static Class loadClass(String className, ClassLoaderService classLoaderService) {
        try {
            return ReflectionTools.loadClass(className, classLoaderService);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public static Class classForName(String className, Map<String, Class<?>> properties, ClassLoaderService classLoaderService) {
        Class aClass = MapProxyTool.loadClass(className, classLoaderService);
        if (aClass == null) {
            aClass = MapProxyTool.generate(className, properties);
        }
        return aClass;
    }

    protected static Class generate(String className, Map<String, Class<?>> properties) {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass cc = pool.makeClass(className);
            cc.addInterface(MapProxyTool.resolveCtClass(Serializable.class));
            cc.addField(new CtField(MapProxyTool.resolveCtClass(Map.class), "theMap", cc));
            cc.addConstructor(MapProxyTool.generateConstructor(className, cc));
            for (Map.Entry<String, Class<?>> entry : properties.entrySet()) {
                cc.addMethod(MapProxyTool.generateGetter(cc, entry.getKey(), entry.getValue()));
                cc.addMethod(MapProxyTool.generateSetter(cc, entry.getKey(), entry.getValue()));
            }
            return cc.toClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CtConstructor generateConstructor(String className, CtClass cc) throws NotFoundException, CannotCompileException {
        StringBuffer sb = new StringBuffer();
        sb.append("public ").append(StringTools.getLastComponent(className)).append("(").append(Map.class.getName()).append(" map)").append("{").append("this.theMap = map;").append("}");
        System.out.println(sb);
        return CtNewConstructor.make((String)sb.toString(), (CtClass)cc);
    }

    private static CtMethod generateGetter(CtClass declaringClass, String fieldName, Class fieldClass) throws CannotCompileException {
        String getterName = "get" + StringTools.capitalizeFirst(fieldName);
        StringBuilder sb = new StringBuilder();
        sb.append("public ").append(fieldClass.getName()).append(" ").append(getterName).append("(){").append("return (").append(fieldClass.getName()).append(")this.theMap.get(\"").append(fieldName).append("\")").append(";").append("}");
        return CtMethod.make((String)sb.toString(), (CtClass)declaringClass);
    }

    private static CtMethod generateSetter(CtClass declaringClass, String fieldName, Class fieldClass) throws CannotCompileException {
        String setterName = "set" + StringTools.capitalizeFirst(fieldName);
        StringBuilder sb = new StringBuilder();
        sb.append("public void ").append(setterName).append("(").append(fieldClass.getName()).append(" ").append(fieldName).append(")").append("{").append("this.theMap.put(\"").append(fieldName).append("\",").append(fieldName).append(")").append(";").append("}");
        return CtMethod.make((String)sb.toString(), (CtClass)declaringClass);
    }

    private static CtClass resolveCtClass(Class clazz) throws NotFoundException {
        return MapProxyTool.resolveCtClass(clazz.getName());
    }

    private static CtClass resolveCtClass(String clazz) throws NotFoundException {
        try {
            ClassPool pool = ClassPool.getDefault();
            return pool.get(clazz);
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

