/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class PasswordIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private SecretKey keyEncryptionKey;

    PasswordIntRecipientInfoGenerator() {
    }

    void setKeyDerivationAlgorithm(AlgorithmIdentifier keyDerivationAlgorithm) {
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
    }

    void setKeyEncryptionKey(SecretKey keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
    }

    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        CMSEnvelopedHelper helper = CMSEnvelopedHelper.INSTANCE;
        String wrapAlgName = helper.getRFC3211WrapperName(this.keyEncryptionKey.getAlgorithm());
        Cipher keyCipher = helper.createSymmetricCipher(wrapAlgName, prov);
        keyCipher.init(3, (Key)this.keyEncryptionKey, random);
        byte[] encryptedKeyBytes = keyCipher.wrap(contentEncryptionKey);
        DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DERObjectIdentifier(this.keyEncryptionKey.getAlgorithm()));
        v.add((DEREncodable)new DEROctetString(keyCipher.getIV()));
        AlgorithmIdentifier keyEncryptionAlgorithm = new AlgorithmIdentifier((DERObjectIdentifier)PKCSObjectIdentifiers.id_alg_PWRI_KEK, (DEREncodable)new DERSequence(v));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, keyEncryptionAlgorithm, (ASN1OctetString)encryptedKey));
    }
}

