/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaAttrCertStore;
import org.bouncycastle.cert.jcajce.JcaCRLStore;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509AttributeCertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509AttributeCertificate;

public class NewSignedDataStreamTest
extends TestCase {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;
    private static final String TEST_MESSAGE = "Hello World!";
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _origDsaKP;
    private static X509Certificate _origDsaCert;
    private static X509CRL _signCrl;
    private static X509CRL _origCrl;
    private static boolean _initialised;

    public NewSignedDataStreamTest(String name) {
        super(name);
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _origDsaKP = CMSTestUtil.makeDsaKeyPair();
            _origDsaCert = CMSTestUtil.makeCertificate(_origDsaKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
            _signCrl = CMSTestUtil.makeCrl(_signKP);
            _origCrl = CMSTestUtil.makeCrl(_origKP);
        }
    }

    private void verifySignatures(CMSSignedDataParser sp, byte[] contentDigest) throws Exception {
        Store certStore = sp.getCertificates();
        Store crlStore = sp.getCRLs();
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            NewSignedDataStreamTest.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert)));
            if (contentDigest == null) continue;
            NewSignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, signer.getContentDigest()));
        }
        NewSignedDataStreamTest.assertEquals((int)certStore.getMatches(null).size(), (int)sp.getCertificates("Collection", BC).getMatches(null).size());
        NewSignedDataStreamTest.assertEquals((int)crlStore.getMatches(null).size(), (int)sp.getCRLs("Collection", BC).getMatches(null).size());
    }

    private void verifySignatures(CMSSignedDataParser sp) throws Exception {
        this.verifySignatures(sp, null);
    }

    private void verifyEncodedData(ByteArrayOutputStream bOut) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        sp.close();
    }

    private void checkSigParseable(byte[] sig) throws Exception {
        CMSSignedDataParser sp = new CMSSignedDataParser(sig);
        sp.getVersion();
        CMSTypedStream sc = sp.getSignedContent();
        if (sc != null) {
            sc.drain();
        }
        sp.getCertificatesAndCRLs("Collection", BC);
        sp.getSignerInfos();
        sp.close();
    }

    public void testEarlyInvalidKeyException() throws Exception {
        try {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSigner(_origKP.getPrivate(), _origCert, "DSA", CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
            NewSignedDataStreamTest.fail((String)"Expected InvalidKeyException in addSigner");
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
    }

    public void testEarlyNoSuchAlgorithmException() throws Exception {
        try {
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataStreamGenerator.DIGEST_SHA1, CMSSignedDataStreamGenerator.DIGEST_SHA1, BC);
            NewSignedDataStreamTest.fail((String)"Expected NoSuchAlgorithmException in addSigner");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void testSha1EncapsulatedSignature() throws Exception {
        byte[] encapSigData = Base64.decode((String)"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");
        CMSSignedDataParser sp = new CMSSignedDataParser(encapSigData);
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testSHA1WithRSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(TEST_MESSAGE.getBytes());
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        siBuilder.setDirectSignature(true);
        gen.addSignerInfoGenerator(siBuilder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate(msg, false);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), s.getEncoded());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testDSANoAttributes() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(TEST_MESSAGE.getBytes());
        certList.add(_origDsaCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        builder.setDirectSignature(true);
        gen.addSignerInfoGenerator(builder.build(new JcaContentSignerBuilder("SHA1withDSA").setProvider(BC).build(_origDsaKP.getPrivate()), _origDsaCert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate(msg);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), s.getEncoded());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testSHA1WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        crlList.add(_signCrl);
        crlList.add(_origCrl);
        JcaCertStore certs = new JcaCertStore(certList);
        JcaCRLStore crls = new JcaCRLStore(crlList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        gen.addCRLs((Store)crls);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), bOut.toByteArray());
        sp.getSignedContent().drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificates(sp.getCertificates());
        gen.addCRLs(sp.getCRLs());
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.verifyEncodedData(bOut);
        Collection col = sp.getCRLs().getMatches(null);
        NewSignedDataStreamTest.assertEquals((int)2, (int)col.size());
        NewSignedDataStreamTest.assertTrue((boolean)col.contains(new JcaX509CRLHolder(_signCrl)));
        NewSignedDataStreamTest.assertTrue((boolean)col.contains(new JcaX509CRLHolder(_origCrl)));
    }

    public void testSHA1WithRSANonData() throws Exception {
        ArrayList<JcaX509CertificateHolder> certList = new ArrayList<JcaX509CertificateHolder>();
        ArrayList<JcaX509CRLHolder> crlList = new ArrayList<JcaX509CRLHolder>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(new JcaX509CertificateHolder(_origCert));
        certList.add(new JcaX509CertificateHolder(_signCert));
        crlList.add(new JcaX509CRLHolder(_signCrl));
        crlList.add(new JcaX509CRLHolder(_origCrl));
        JcaCertStore certs = new JcaCertStore(certList);
        JcaCRLStore crls = new JcaCRLStore(crlList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        gen.addCRLs((Store)crls);
        OutputStream sigOut = gen.open(new ASN1ObjectIdentifier("1.2.3.4"), bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        CMSTypedStream stream = sp.getSignedContent();
        NewSignedDataStreamTest.assertEquals((Object)new ASN1ObjectIdentifier("1.2.3.4"), (Object)stream.getContentType());
        stream.drain();
        MessageDigest md = MessageDigest.getInstance("SHA1", BC);
        this.verifySignatures(sp, md.digest(TEST_MESSAGE.getBytes()));
    }

    public void testSHA1AndMD5WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        ContentSigner md5Signer = new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(sha1Signer, _origCert));
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(md5Signer, _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(TEST_MESSAGE.getBytes())), bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testSHA1WithRSAEncapsulatedBufferedStream() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        int unbufferedLength = bOut.toByteArray().length;
        bOut = new ByteArrayOutputStream();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        sigOut = gen.open(bOut, true);
        BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, 300);
        for (int i = 0; i != 2000; ++i) {
            bfOut.write(i & 0xFF);
        }
        bfOut.close();
        this.verifyEncodedData(bOut);
        NewSignedDataStreamTest.assertTrue((bOut.toByteArray().length == unbufferedLength ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulatedBuffered() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        int unbufferedLength = bOut.toByteArray().length;
        bOut = new ByteArrayOutputStream();
        gen = new CMSSignedDataStreamGenerator();
        gen.setBufferSize(300);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        sigOut = gen.open(bOut, true);
        for (int i = 0; i != 2000; ++i) {
            sigOut.write(i & 0xFF);
        }
        sigOut.close();
        this.verifyEncodedData(bOut);
        NewSignedDataStreamTest.assertTrue((bOut.toByteArray().length > unbufferedLength ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(CMSSignedGenerator.DIGEST_SHA1);
        AttributeTable table = ((SignerInformation)sp.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute hash = table.get((DERObjectIdentifier)CMSAttributes.messageDigest);
        NewSignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificates(sp.getCertificates());
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(TEST_MESSAGE.getBytes()), bOut.toByteArray());
        NewSignedDataStreamTest.assertEquals((int)1, (int)sd.getSignerInfos().getSigners().size());
        this.verifyEncodedData(bOut);
    }

    public void testSHA1WithRSAEncapsulatedSubjectKeyID() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, CMSTestUtil.createSubjectKeyId(_origCert.getPublicKey()).getKeyIdentifier()));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(CMSSignedGenerator.DIGEST_SHA1);
        AttributeTable table = ((SignerInformation)sp.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute hash = table.get((DERObjectIdentifier)CMSAttributes.messageDigest);
        NewSignedDataStreamTest.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
        gen = new CMSSignedDataStreamGenerator();
        gen.addSigners(sp.getSignerInfos());
        gen.addCertificates(sp.getCertificates());
        bOut.reset();
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(TEST_MESSAGE.getBytes()), bOut.toByteArray());
        NewSignedDataStreamTest.assertEquals((int)1, (int)sd.getSignerInfos().getSigners().size());
        this.verifyEncodedData(bOut);
    }

    public void testAttributeGenerators() throws Exception {
        final DERObjectIdentifier dummyOid1 = new DERObjectIdentifier("1.2.3");
        final DERObjectIdentifier dummyOid2 = new DERObjectIdentifier("1.2.3.4");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        DefaultSignedAttributeTableGenerator signedGen = new DefaultSignedAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) {
                Hashtable table = this.createStandardAttributeTable(parameters);
                DEROctetString val = new DEROctetString((byte[])parameters.get("digest"));
                Attribute attr = new Attribute(dummyOid1, (ASN1Set)new DERSet((DEREncodable)val));
                table.put(attr.getAttrType(), attr);
                return new AttributeTable(table);
            }
        };
        CMSAttributeTableGenerator unsignedGen = new CMSAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) {
                DEROctetString val = new DEROctetString((byte[])parameters.get("encryptedDigest"));
                Attribute attr = new Attribute(dummyOid2, (ASN1Set)new DERSet((DEREncodable)val));
                return new AttributeTable((ASN1Set)new DERSet((DEREncodable)attr));
            }
        };
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        JcaSignerInfoGeneratorBuilder siBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        siBuilder.setSignedAttributeGenerator(signedGen).setUnsignedAttributeGenerator(unsignedGen);
        gen.addSignerInfoGenerator(siBuilder.build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
        SignerInformationStore signers = sp.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            this.checkAttribute(signer.getContentDigest(), signer.getSignedAttributes().get(dummyOid1));
            this.checkAttribute(signer.getSignature(), signer.getUnsignedAttributes().get(dummyOid2));
        }
    }

    private void checkAttribute(byte[] expected, Attribute attr) {
        DEROctetString value = (DEROctetString)attr.getAttrValues().getObjectAt(0);
        NewSignedDataStreamTest.assertEquals((Object)new DEROctetString(expected), (Object)value);
    }

    public void testWithAttributeCertificate() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(_origKP.getPrivate());
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build()).build(sha1Signer, _origCert));
        gen.addCertificates((Store)certs);
        X509AttributeCertificate attrCert = CMSTestUtil.getAttributeCertificate();
        JcaAttrCertStore store = new JcaAttrCertStore(Collections.singleton(attrCert));
        gen.addAttributeCertificates((Store)store);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        NewSignedDataStreamTest.assertEquals((int)4, (int)sp.getVersion());
        store = sp.getAttributeCertificates();
        Collection coll = store.getMatches(null);
        NewSignedDataStreamTest.assertEquals((int)1, (int)coll.size());
        NewSignedDataStreamTest.assertTrue((boolean)coll.contains(new JcaX509AttributeCertificateHolder(attrCert)));
    }

    public void testSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] data = TEST_MESSAGE.getBytes();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, false);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        bOut.reset();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA224withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        sigOut = gen.open(bOut);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        CMSSignedData sd = new CMSSignedData(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceSigners(original, sd.getSignerInfos(), newOut);
        sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), newOut.toByteArray());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        NewSignedDataStreamTest.assertEquals((String)signer.getDigestAlgOID(), (String)CMSSignedDataStreamGenerator.DIGEST_SHA224);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(data)), newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedSignerStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        bOut.reset();
        gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA224withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedData sd = new CMSSignedData(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceSigners(original, sd.getSignerInfos(), newOut);
        sd = new CMSSignedData(newOut.toByteArray());
        SignerInformation signer = (SignerInformation)sd.getSignerInfos().getSigners().iterator().next();
        NewSignedDataStreamTest.assertEquals((String)signer.getDigestAlgOID(), (String)CMSSignedDataStreamGenerator.DIGEST_SHA224);
        CMSSignedDataParser sp = new CMSSignedDataParser(newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] data = TEST_MESSAGE.getBytes();
        certList.add(_origDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        gen.addSignerInfoGenerator(builder.build(new JcaContentSignerBuilder("SHA1withRSA").build(_origKP.getPrivate()), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut);
        sigOut.write(data);
        sigOut.close();
        this.checkSigParseable(bOut.toByteArray());
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceCertificatesAndCRLs(original, (Store)certs, null, null, newOut);
        CMSSignedDataParser sp = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream(data)), newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testEncapsulatedCertStoreReplacement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origDsaCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        gen.addSignerInfoGenerator(builder.build(new JcaContentSignerBuilder("SHA1withRSA").build(_origKP.getPrivate()), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        certList = new ArrayList();
        certList.add(_origCert);
        certList.add(_signCert);
        certs = new JcaCertStore(certList);
        ByteArrayInputStream original = new ByteArrayInputStream(bOut.toByteArray());
        ByteArrayOutputStream newOut = new ByteArrayOutputStream();
        CMSSignedDataParser.replaceCertificatesAndCRLs(original, (Store)certs, null, null, newOut);
        CMSSignedDataParser sp = new CMSSignedDataParser(newOut.toByteArray());
        sp.getSignedContent().drain();
        this.verifySignatures(sp);
    }

    public void testCertOrdering1() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_origCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        certs = sp.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        NewSignedDataStreamTest.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        NewSignedDataStreamTest.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
    }

    public void testCertOrdering2() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withRSA", _origKP.getPrivate(), _origCert));
        gen.addCertificates((Store)certs);
        OutputStream sigOut = gen.open(bOut, true);
        sigOut.write(TEST_MESSAGE.getBytes());
        sigOut.close();
        CMSSignedDataParser sp = new CMSSignedDataParser(bOut.toByteArray());
        sp.getSignedContent().drain();
        certs = sp.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        NewSignedDataStreamTest.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        NewSignedDataStreamTest.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
    }

    public static Test suite() throws Exception {
        NewSignedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(NewSignedDataStreamTest.class));
    }

    static {
        _initialised = false;
    }
}

