/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.BinaryHolder;
import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.CipherCallback;
import com.mongodb.crypt.capi.Logger;
import com.mongodb.crypt.capi.Loggers;
import com.mongodb.crypt.capi.MacCallback;
import com.mongodb.crypt.capi.MessageDigestCallback;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptContextImpl;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.crypt.capi.SecureRandomCallback;
import com.mongodb.crypt.capi.SigningRSAESPKCSCallback;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

class MongoCryptImpl
implements MongoCrypt {
    private static final Logger LOGGER = Loggers.getLogger();
    private final CAPI.mongocrypt_t wrapped;
    private final LogCallback logCallback;
    private final CipherCallback aesCBC256EncryptCallback;
    private final CipherCallback aesCBC256DecryptCallback;
    private final CipherCallback aesCTR256EncryptCallback;
    private final CipherCallback aesCTR256DecryptCallback;
    private final MacCallback hmacSha512Callback;
    private final MacCallback hmacSha256Callback;
    private final MessageDigestCallback sha256Callback;
    private final SecureRandomCallback secureRandomCallback;
    private final SigningRSAESPKCSCallback signingRSAESPKCSCallback;
    private final AtomicBoolean closed = new AtomicBoolean();

    MongoCryptImpl(MongoCryptOptions options) {
        this.wrapped = CAPI.mongocrypt_new();
        if (this.wrapped == null) {
            throw new MongoCryptException("Unable to create new mongocrypt object");
        }
        this.logCallback = new LogCallback();
        this.configure(() -> CAPI.mongocrypt_setopt_log_handler(this.wrapped, this.logCallback, null));
        this.aesCBC256EncryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 1);
        this.aesCBC256DecryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 2);
        this.aesCTR256EncryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 1);
        this.aesCTR256DecryptCallback = new CipherCallback("AES", "AES/CTR/NoPadding", 2);
        this.hmacSha512Callback = new MacCallback("HmacSHA512");
        this.hmacSha256Callback = new MacCallback("HmacSHA256");
        this.sha256Callback = new MessageDigestCallback("SHA-256");
        this.secureRandomCallback = new SecureRandomCallback(new SecureRandom());
        this.configure(() -> CAPI.mongocrypt_setopt_crypto_hooks(this.wrapped, this.aesCBC256EncryptCallback, this.aesCBC256DecryptCallback, this.secureRandomCallback, this.hmacSha512Callback, this.hmacSha256Callback, this.sha256Callback, null));
        this.signingRSAESPKCSCallback = new SigningRSAESPKCSCallback();
        this.configure(() -> CAPI.mongocrypt_setopt_crypto_hook_sign_rsaes_pkcs1_v1_5(this.wrapped, this.signingRSAESPKCSCallback, null));
        this.configure(() -> CAPI.mongocrypt_setopt_aes_256_ctr(this.wrapped, this.aesCTR256EncryptCallback, this.aesCTR256DecryptCallback, null));
        if (options.getLocalKmsProviderOptions() != null) {
            try (BinaryHolder localMasterKeyBinaryHolder = CAPIHelper.toBinary(options.getLocalKmsProviderOptions().getLocalMasterKey());){
                this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_local(this.wrapped, localMasterKeyBinaryHolder.getBinary()));
            }
        }
        if (options.getAwsKmsProviderOptions() != null) {
            this.configure(() -> CAPI.mongocrypt_setopt_kms_provider_aws(this.wrapped, new CAPI.cstring(options.getAwsKmsProviderOptions().getAccessKeyId()), -1, new CAPI.cstring(options.getAwsKmsProviderOptions().getSecretAccessKey()), -1));
        }
        if (options.isNeedsKmsCredentialsStateEnabled()) {
            CAPI.mongocrypt_setopt_use_need_kms_credentials_state(this.wrapped);
        }
        if (options.getKmsProviderOptions() != null) {
            try (BinaryHolder binaryHolder = CAPIHelper.toBinary(options.getKmsProviderOptions());){
                this.configure(() -> CAPI.mongocrypt_setopt_kms_providers(this.wrapped, binaryHolder.getBinary()));
            }
        }
        if (options.getLocalSchemaMap() != null) {
            BsonDocument localSchemaMapDocument = new BsonDocument();
            localSchemaMapDocument.putAll(options.getLocalSchemaMap());
            try (BinaryHolder localSchemaMapBinaryHolder = CAPIHelper.toBinary(localSchemaMapDocument);){
                this.configure(() -> CAPI.mongocrypt_setopt_schema_map(this.wrapped, localSchemaMapBinaryHolder.getBinary()));
            }
        }
        if (options.isBypassQueryAnalysis()) {
            CAPI.mongocrypt_setopt_bypass_query_analysis(this.wrapped);
        }
        if (options.getEncryptedFieldsMap() != null) {
            BsonDocument localEncryptedFieldsMap = new BsonDocument();
            localEncryptedFieldsMap.putAll(options.getEncryptedFieldsMap());
            try (BinaryHolder localEncryptedFieldsMapHolder = CAPIHelper.toBinary(localEncryptedFieldsMap);){
                this.configure(() -> CAPI.mongocrypt_setopt_encrypted_field_config_map(this.wrapped, localEncryptedFieldsMapHolder.getBinary()));
            }
        }
        options.getSearchPaths().forEach(p -> CAPI.mongocrypt_setopt_append_crypt_shared_lib_search_path(this.wrapped, new CAPI.cstring((String)p)));
        if (options.getExtraOptions().containsKey((Object)"cryptSharedLibPath")) {
            CAPI.mongocrypt_setopt_set_crypt_shared_lib_path_override(this.wrapped, new CAPI.cstring(options.getExtraOptions().getString((Object)"cryptSharedLibPath").getValue()));
        }
        this.configure(() -> CAPI.mongocrypt_init(this.wrapped));
    }

    @Override
    public MongoCryptContext createEncryptionContext(String database, BsonDocument commandDocument) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        Assertions.notNull((String)"database", (Object)database);
        Assertions.notNull((String)"commandDocument", (Object)commandDocument);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder commandDocumentBinaryHolder = CAPIHelper.toBinary(commandDocument);){
            this.configure(() -> CAPI.mongocrypt_ctx_encrypt_init(context, new CAPI.cstring(database), -1, commandDocumentBinaryHolder.getBinary()), context);
            MongoCryptContextImpl mongoCryptContextImpl = new MongoCryptContextImpl(context);
            return mongoCryptContextImpl;
        }
    }

    @Override
    public MongoCryptContext createDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_decrypt_init(context, documentBinaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createDataKeyContext(String kmsProvider, MongoDataKeyOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        BsonDocument keyDocument = new BsonDocument("provider", (BsonValue)new BsonString(kmsProvider));
        BsonDocument masterKey = options.getMasterKey();
        if (masterKey != null) {
            masterKey.forEach((arg_0, arg_1) -> ((BsonDocument)keyDocument).append(arg_0, arg_1));
        }
        try (BinaryHolder masterKeyHolder = CAPIHelper.toBinary(keyDocument);){
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_encryption_key(context, masterKeyHolder.getBinary()), context);
        }
        if (options.getKeyAltNames() != null) {
            for (String cur : options.getKeyAltNames()) {
                try (BinaryHolder keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(cur)));){
                    this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary()), context);
                }
            }
        }
        if (options.getKeyMaterial() != null) {
            try (BinaryHolder keyMaterialBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyMaterial", (BsonValue)new BsonBinary(options.getKeyMaterial())));){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_material(context, keyMaterialBinaryHolder.getBinary()), context);
            }
        }
        if (!CAPI.mongocrypt_ctx_datakey_init(context)) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitEncryptionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = this.configureExplicitEncryption(options);
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_explicit_encrypt_init(context, documentBinaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createEncryptExpressionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = this.configureExplicitEncryption(options);
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_explicit_encrypt_expression_init(context, documentBinaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(document);){
            this.configure(() -> CAPI.mongocrypt_ctx_explicit_decrypt_init(context, binaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createRewrapManyDatakeyContext(BsonDocument filter, MongoRewrapManyDataKeyOptions options) {
        Assertions.isTrue((String)"open", (!this.closed.get() ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (options != null && options.getProvider() != null) {
            BsonDocument keyDocument = new BsonDocument("provider", (BsonValue)new BsonString(options.getProvider()));
            BsonDocument masterKey = options.getMasterKey();
            if (masterKey != null) {
                masterKey.forEach((arg_0, arg_1) -> ((BsonDocument)keyDocument).append(arg_0, arg_1));
            }
            try (BinaryHolder binaryHolder = CAPIHelper.toBinary(keyDocument);){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_encryption_key(context, binaryHolder.getBinary()), context);
            }
        }
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(filter);){
            this.configure(() -> CAPI.mongocrypt_ctx_rewrap_many_datakey_init(context, binaryHolder.getBinary()), context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public String getCryptSharedLibVersionString() {
        CAPI.cstring versionString = CAPI.mongocrypt_crypt_shared_lib_version_string(this.wrapped, null);
        return versionString == null ? null : versionString.toString();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            CAPI.mongocrypt_destroy(this.wrapped);
        }
    }

    private CAPI.mongocrypt_ctx_t configureExplicitEncryption(MongoExplicitEncryptOptions options) {
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (options.getKeyId() != null) {
            try (BinaryHolder keyIdBinaryHolder = CAPIHelper.toBinary(ByteBuffer.wrap(options.getKeyId().getData()));){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_id(context, keyIdBinaryHolder.getBinary()), context);
            }
        }
        if (options.getKeyAltName() != null) {
            try (BinaryHolder keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(options.getKeyAltName())));){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary()), context);
            }
        }
        if (options.getAlgorithm() != null) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_algorithm(context, new CAPI.cstring(options.getAlgorithm()), -1), context);
        }
        if (options.getQueryType() != null) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_query_type(context, new CAPI.cstring(options.getQueryType()), -1), context);
        }
        if (options.getContentionFactor() != null) {
            this.configure(() -> CAPI.mongocrypt_ctx_setopt_contention_factor(context, options.getContentionFactor()), context);
        }
        if (options.getRangeOptions() != null) {
            try (BinaryHolder rangeOptionsHolder = CAPIHelper.toBinary(options.getRangeOptions());){
                this.configure(() -> CAPI.mongocrypt_ctx_setopt_algorithm_range(context, rangeOptionsHolder.getBinary()), context);
            }
        }
        return context;
    }

    private void configure(Supplier<Boolean> successSupplier) {
        if (!successSupplier.get().booleanValue()) {
            this.throwExceptionFromStatus();
        }
    }

    private void configure(Supplier<Boolean> successSupplier, CAPI.mongocrypt_ctx_t context) {
        if (!successSupplier.get().booleanValue()) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    static class LogCallback
    implements CAPI.mongocrypt_log_fn_t {
        LogCallback() {
        }

        @Override
        public void log(int level, CAPI.cstring message, int messageLength, Pointer ctx) {
            if (level == 0) {
                LOGGER.error(message.toString());
            }
            if (level == 1) {
                LOGGER.error(message.toString());
            }
            if (level == 2) {
                LOGGER.warn(message.toString());
            }
            if (level == 3) {
                LOGGER.info(message.toString());
            }
            if (level == 4) {
                LOGGER.trace(message.toString());
            }
        }
    }
}

