/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.ParameterExpression;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

public class ParameterMappingSourceParser {
    private static final String VALID_PROPERTIES = "javaType,jdbcType,mode,numericScale,resultMap,typeHandler,jdbcTypeName";
    private final String sql;
    private final ParameterMapping[] parameterMappingSources;

    public ParameterMappingSourceParser(Configuration configuration, String script, Class<?> parameterType) {
        ParameterMappingTokenHandler handler = new ParameterMappingTokenHandler(configuration, parameterType);
        GenericTokenParser parser = new GenericTokenParser("@{", "}", (TokenHandler)handler);
        this.sql = parser.parse(script);
        this.parameterMappingSources = handler.getParameterMappingSources();
    }

    public ParameterMapping[] getParameterMappingSources() {
        return this.parameterMappingSources;
    }

    public String getSql() {
        return this.sql;
    }

    private static class ParameterMappingTokenHandler
    extends BaseBuilder
    implements TokenHandler {
        private final List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        private final Class<?> parameterType;

        public ParameterMappingTokenHandler(Configuration configuration, Class<?> parameterType) {
            super(configuration);
            this.parameterType = parameterType;
        }

        public ParameterMapping[] getParameterMappingSources() {
            return this.parameterMappings.toArray(new ParameterMapping[this.parameterMappings.size()]);
        }

        public String handleToken(String content) {
            int index = this.parameterMappings.size();
            ParameterMapping pm = this.buildParameterMapping(content);
            this.parameterMappings.add(pm);
            return '$' + "_pmc" + ".g(" + index + ")";
        }

        private ParameterMapping buildParameterMapping(String content) {
            MetaClass metaClass;
            Map<String, String> propertiesMap = this.parseParameterMapping(content);
            String property = propertiesMap.get("property");
            String jdbcType = propertiesMap.get("jdbcType");
            Class<Object> propertyType = this.typeHandlerRegistry.hasTypeHandler(this.parameterType) ? this.parameterType : (JdbcType.CURSOR.name().equals(jdbcType) ? ResultSet.class : (property != null ? ((metaClass = MetaClass.forClass(this.parameterType)).hasGetter(property) ? metaClass.getGetterType(property) : Object.class) : Object.class));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, propertyType);
            if (jdbcType != null) {
                builder.jdbcType(this.resolveJdbcType(jdbcType));
            }
            Class javaType = null;
            String typeHandlerAlias = null;
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if ("javaType".equals(name)) {
                    javaType = this.resolveClass(value);
                    builder.javaType(javaType);
                    continue;
                }
                if ("jdbcType".equals(name)) {
                    builder.jdbcType(this.resolveJdbcType(value));
                    continue;
                }
                if ("mode".equals(name)) {
                    builder.mode(this.resolveParameterMode(value));
                    continue;
                }
                if ("numericScale".equals(name)) {
                    builder.numericScale(Integer.valueOf(value));
                    continue;
                }
                if ("resultMap".equals(name)) {
                    builder.resultMapId(value);
                    continue;
                }
                if ("typeHandler".equals(name)) {
                    typeHandlerAlias = value;
                    continue;
                }
                if ("jdbcTypeName".equals(name)) {
                    builder.jdbcTypeName(value);
                    continue;
                }
                if ("property".equals(name)) continue;
                if ("expression".equals(name)) {
                    throw new BuilderException("Expression based parameters are not supported yet");
                }
                throw new BuilderException("An invalid property '" + name + "' was found in mapping @{" + content + "}.  Valid properties are " + ParameterMappingSourceParser.VALID_PROPERTIES);
            }
            if (typeHandlerAlias != null) {
                builder.typeHandler(this.resolveTypeHandler(javaType, typeHandlerAlias));
            }
            return builder.build();
        }

        private Map<String, String> parseParameterMapping(String content) {
            try {
                return new ParameterExpression(content);
            }
            catch (BuilderException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BuilderException("Parsing error was found in mapping @{" + content + "}.  Check syntax #{property|(expression), var1=value1, var2=value2, ...} ", (Throwable)ex);
            }
        }
    }
}

