/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.velocity.ParameterMappingCollector;
import org.mybatis.scripting.velocity.ParameterMappingSourceParser;
import org.mybatis.scripting.velocity.VelocityFacade;

public class SQLScriptSource
implements SqlSource {
    protected static final String PARAMETER_OBJECT_KEY = "_parameter";
    protected static final String DATABASE_ID_KEY = "_databaseId";
    protected static final String MAPPING_COLLECTOR_KEY = "_pmc";
    protected static final String VARIABLES_KEY = "_vars";
    private static int templateIndex = 0;
    private final ParameterMapping[] parameterMappingSources;
    private final Object compiledScript;
    private final Configuration configuration;

    public SQLScriptSource(Configuration configuration, String script, Class<?> parameterTypeClass) {
        this.configuration = configuration;
        ParameterMappingSourceParser mappingParser = new ParameterMappingSourceParser(configuration, script, parameterTypeClass);
        this.parameterMappingSources = mappingParser.getParameterMappingSources();
        script = mappingParser.getSql();
        this.compiledScript = VelocityFacade.compile(script, "velocity-template-" + ++templateIndex);
    }

    public BoundSql getBoundSql(Object parameterObject) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ParameterMappingCollector pmc = new ParameterMappingCollector(this.parameterMappingSources, context, this.configuration);
        context.put(DATABASE_ID_KEY, this.configuration.getDatabaseId());
        context.put(PARAMETER_OBJECT_KEY, parameterObject);
        context.put(MAPPING_COLLECTOR_KEY, pmc);
        context.put(VARIABLES_KEY, this.configuration.getVariables());
        String sql = VelocityFacade.apply(this.compiledScript, context);
        BoundSql boundSql = new BoundSql(this.configuration, sql, pmc.getParameterMappings(), parameterObject);
        for (Map.Entry entry : context.entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
        return boundSql;
    }
}

