/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;
import org.mybatis.scripting.velocity.FastLinkedList;

public class TrimDirective
extends Directive {
    public String getName() {
        return "trim";
    }

    public final int getType() {
        return 1;
    }

    public final boolean render(InternalContextAdapter ica, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Params p = this.getParams(ica, node);
        if (p == null) {
            return false;
        }
        return this.render(p, writer);
    }

    public boolean render(Params params, Writer writer) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        FastLinkedList.Node n;
        int leftIndex = 0;
        int rightIndex = params.maxBody;
        if (!params.prefixOverrides.isEmpty()) {
            String LEFT = params.body.substring(0, params.maxPrefixLength < params.maxBody ? params.maxPrefixLength : params.maxBody).toUpperCase(Locale.ENGLISH);
            n = params.prefixOverrides.start();
            while (n != null) {
                if (LEFT.startsWith((String)n.data)) {
                    leftIndex = ((String)n.data).length();
                    break;
                }
                n = n.next;
            }
        }
        if (!params.suffixOverrides.isEmpty()) {
            String RIGHT = params.body.substring(rightIndex - params.maxSuffixLength).toUpperCase(Locale.ENGLISH);
            n = params.suffixOverrides.start();
            while (n != null) {
                if (RIGHT.endsWith((String)n.data)) {
                    rightIndex -= ((String)n.data).length();
                    break;
                }
                n = n.next;
            }
        }
        writer.append(params.prefix).append(' ');
        writer.append(params.body, leftIndex, rightIndex).append(' ');
        writer.append(params.suffix);
        return true;
    }

    protected Params getParams(InternalContextAdapter context, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Params params = new Params();
        int nodes = node.jjtGetNumChildren();
        for (int i = 0; i < nodes; ++i) {
            Node child = node.jjtGetChild(i);
            if (child == null) continue;
            if (!(child instanceof ASTBlock)) {
                if (i == 0) {
                    params.setPrefix(String.valueOf(child.value(context)));
                    continue;
                }
                if (i == 1) {
                    params.setPrefixOverrides(String.valueOf(child.value(context)).toUpperCase(Locale.ENGLISH));
                    continue;
                }
                if (i == 2) {
                    params.setSuffix(String.valueOf(child.value(context)));
                    continue;
                }
                if (i != 3) break;
                params.setSuffixOverrides(String.valueOf(child.value(context)).toUpperCase(Locale.ENGLISH));
                continue;
            }
            StringWriter blockContent = new StringWriter();
            child.render(context, (Writer)blockContent);
            params.setBody(blockContent.toString().trim());
            break;
        }
        return params;
    }

    private static int fromStringList(String list, char sep, FastLinkedList<String> fll) {
        int max = 0;
        if (list != null) {
            int r;
            int n = list.length();
            int i = 0;
            while (i < n && i < (r = list.indexOf(sep, i))) {
                fll.add(list.substring(i, r));
                int len = r - i;
                if (len > max) {
                    max = len;
                }
                i = r + 1;
            }
            if (i < n) {
                fll.add(list.substring(i));
                int len = n - i;
                if (len > max) {
                    max = len;
                }
            }
        }
        return max;
    }

    protected static final class Params {
        String prefix = "";
        String suffix = "";
        FastLinkedList<String> prefixOverrides = new FastLinkedList();
        FastLinkedList<String> suffixOverrides = new FastLinkedList();
        String body = "";
        int maxPrefixLength = 0;
        int maxSuffixLength = 0;
        int maxBody = 0;

        protected Params() {
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body == null ? "" : body.trim();
            this.maxBody = this.body.length();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public FastLinkedList<String> getPrefixOverrides() {
            return this.prefixOverrides;
        }

        public void setPrefixOverrides(String list) {
            this.maxPrefixLength = TrimDirective.fromStringList(list, '|', this.prefixOverrides);
        }

        public FastLinkedList<String> getSuffixOverrides() {
            return this.suffixOverrides;
        }

        public void setSuffixOverrides(String list) {
            this.maxSuffixLength = TrimDirective.fromStringList(list, '|', this.suffixOverrides);
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }
}

