/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxMetrics;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.MonoMetrics;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class MonoMetricsFuseable<T>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final String name;
    final Tags tags;
    final MeterRegistry registryCandidate;

    MonoMetricsFuseable(Mono<? extends T> mono) {
        this(mono, null);
    }

    MonoMetricsFuseable(Mono<? extends T> mono, @Nullable MeterRegistry registryCandidate) {
        super(mono);
        this.name = FluxMetrics.resolveName(mono);
        this.tags = FluxMetrics.resolveTags(mono, FluxMetrics.DEFAULT_TAGS_MONO, this.name);
        this.registryCandidate = registryCandidate == null ? Metrics.globalRegistry : registryCandidate;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MetricsFuseableSubscriber<T>(actual, this.registryCandidate, Clock.SYSTEM, this.tags);
    }

    static final class MetricsFuseableSubscriber<T>
    extends MonoMetrics.MetricsSubscriber<T>
    implements Fuseable,
    Fuseable.QueueSubscription<T> {
        int mode;
        @Nullable
        Fuseable.QueueSubscription<T> qs;

        MetricsFuseableSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, Tags sequenceTags) {
            super(actual, registry, clock, sequenceTags);
        }

        @Override
        public void clear() {
            if (this.qs != null) {
                this.qs.clear();
            }
        }

        @Override
        public void onComplete() {
            if (this.mode == 2) {
                this.actual.onComplete();
            } else {
                if (this.done) {
                    return;
                }
                this.done = true;
                FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
                this.actual.onComplete();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.mode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    FluxMetrics.recordMalformed(this.commonTags, this.registry);
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
                this.actual.onNext(t);
                this.actual.onComplete();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.qs == null || this.qs.isEmpty();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                FluxMetrics.recordOnSubscribe(this.commonTags, this.registry);
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                this.qs = Operators.as(s);
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        @Nullable
        public T poll() {
            if (this.qs == null) {
                return null;
            }
            try {
                Object v = this.qs.poll();
                if (!(this.done || v == null && this.mode != 1)) {
                    FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
                }
                this.done = true;
                return (T)v;
            }
            catch (Throwable e) {
                FluxMetrics.recordOnError(this.commonTags, this.registry, this.subscribeToTerminateSample, e);
                throw e;
            }
        }

        @Override
        public int requestFusion(int mode) {
            if (this.qs != null) {
                this.mode = this.qs.requestFusion(mode);
                return this.mode;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.qs == null ? 0 : this.qs.size();
        }
    }
}

