/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.languages.LibraryDependency;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpClientCodegen
extends AbstractCSharpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(CSharpClientCodegen.class);
    private static final String NUNIT = "nunit";
    private static final String RESTSHARP = "restsharp";
    private static final String NEWTONSOFT_JSON = "newtonsoft-json";
    private static final String JSON_SUBTYPES = "json-subtypes";
    private static final String FODY = "fody";
    private static final String PROPERTYCHANGED_FODY = "propertychanged-fody";
    private static final String NET452 = "v4.5.2";
    private static final String NET45 = "v4.5";
    private static final String NET40 = "v4.0";
    private static final String NET35 = "v3.5";
    private static final String NETSTANDARD = "netstandard1.3";
    private static final String UWP = "uwp";
    private static final String MCS_NET_VERSION_KEY = "x-mcs-sdk";
    protected String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected String clientPackage = "Org.OpenAPITools.Client";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String targetFramework = "v4.5";
    protected String targetFrameworkNuget = "net45";
    protected boolean supportsAsync = Boolean.TRUE;
    protected boolean supportsUWP = Boolean.FALSE;
    protected boolean netStandard = Boolean.FALSE;
    protected boolean generatePropertyChanged = Boolean.FALSE;
    protected boolean validatable = Boolean.TRUE;
    protected Map<Character, String> regexModifiers;
    protected final Map<String, String> frameworks;
    protected boolean nonPublicApi = Boolean.FALSE;
    protected boolean useCompareNetObjects = Boolean.FALSE;
    protected boolean caseInsensitiveResponseHeaders = Boolean.FALSE;

    public CSharpClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.cliOptions.clear();
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("decimal", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.setSupportNullable(Boolean.TRUE);
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("interfacePrefix", "Prefix interfaces with a community standard or widely accepted prefix.", this.interfacePrefix);
        CliOption framework = new CliOption("targetFramework", "The target .NET framework version. To target multiple frameworks, use `;` as the separator, e.g. `netstandard2.1;netcoreapp3.0`");
        this.frameworks = new ImmutableMap.Builder().put((Object)NET35, (Object)".NET Framework 3.5 compatible").put((Object)NET40, (Object)".NET Framework 4.0 compatible").put((Object)NET45, (Object)".NET Framework 4.5 compatible").put((Object)NET452, (Object)".NET Framework 4.5.2+ compatible").put((Object)NETSTANDARD, (Object)".NET Standard 1.3 compatible (DEPRECATED. Please use `csharp-netcore` generator instead)").put((Object)UWP, (Object)"Universal Windows Platform (DEPRECATED. Please use `csharp-netcore` generator instead)").build();
        framework.defaultValue(this.targetFramework);
        framework.setEnum(this.frameworks);
        this.cliOptions.add(framework);
        CliOption modelPropertyNaming = new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name");
        this.cliOptions.add(modelPropertyNaming.defaultValue("PascalCase"));
        this.addSwitch("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.hideGenerationTimestamp);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch("optionalMethodArgument", "C# Optional method argument, e.g. void square(int x=10) (.net 4.0+ only).", this.optionalMethodArgumentFlag);
        this.addSwitch("optionalAssemblyInfo", "Generate AssemblyInfo.cs.", this.optionalAssemblyInfoFlag);
        this.addSwitch("optionalEmitDefaultValues", "Set DataMember's EmitDefaultValue.", this.optionalEmitDefaultValuesFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("generatePropertyChanged", "Specifies a AssemblyDescription for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.generatePropertyChanged);
        this.addSwitch("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers.", this.nonPublicApi);
        this.addSwitch("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false", this.allowUnicodeIdentifiers);
        this.addSwitch("netCoreProjectFile", "Use the new format (.NET Core) for .NET project files (.csproj).", this.netCoreProjectFileFlag);
        this.addSwitch("validatable", "Generates self-validatable models.", this.validatable);
        this.addSwitch("useCompareNetObjects", "Use KellermanSoftware.CompareNetObjects for deep recursive object comparison. WARNING: this option incurs potential performance impact.", this.useCompareNetObjects);
        this.addSwitch("caseInsensitiveResponseHeaders", "Make API response's headers case-insensitive", this.caseInsensitiveResponseHeaders);
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IgnoreCase");
        this.regexModifiers.put(Character.valueOf('m'), "Multiline");
        this.regexModifiers.put(Character.valueOf('s'), "Singleline");
        this.regexModifiers.put(Character.valueOf('x'), "IgnorePatternWhitespace");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.apiPackage)) {
            this.setApiPackage("Api");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelPackage)) {
            this.setModelPackage("Model");
        }
        this.clientPackage = "Client";
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = this.convertPropertyToBooleanAndWriteBack("excludeTests");
        }
        if (this.additionalProperties.containsKey("validatable")) {
            this.setValidatable(this.convertPropertyToBooleanAndWriteBack("validatable"));
        } else {
            this.additionalProperties.put("validatable", this.validatable);
        }
        if (this.additionalProperties.containsKey("targetFramework")) {
            this.setTargetFramework((String)this.additionalProperties.get("targetFramework"));
        } else {
            this.setTargetFramework(NET45);
            this.additionalProperties.put("targetFramework", this.targetFramework);
        }
        if (NET35.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4");
            this.additionalProperties.put("net35", true);
            if (this.additionalProperties.containsKey("supportsAsync")) {
                this.LOGGER.warn(".NET 3.5 generator does not support async.");
                this.additionalProperties.remove("supportsAsync");
            }
            this.setTargetFrameworkNuget("net35");
            this.setValidatable(Boolean.FALSE);
            this.setSupportsAsync(Boolean.FALSE);
        } else if (NETSTANDARD.equals(this.targetFramework)) {
            this.LOGGER.warn(".NET Standard 1.3 support has been DEPRECATED in this generator. Please use `csharp-netcore` generator instead.");
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.6-api");
            if (this.additionalProperties.containsKey("supportsUWP")) {
                this.LOGGER.warn(".NET {} generator does not support UWP.", (Object)NETSTANDARD);
                this.additionalProperties.remove("supportsUWP");
            }
            this.setTargetFrameworkNuget(NETSTANDARD);
            this.setSupportsAsync(Boolean.TRUE);
            this.setSupportsUWP(Boolean.FALSE);
            this.setNetStandard(Boolean.TRUE);
            excludeTests = true;
        } else if (UWP.equals(this.targetFramework)) {
            this.LOGGER.warn("UWP support has been DEPRECATED in this generator. Please use `csharp-netcore` generator instead.");
            this.setTargetFrameworkNuget(UWP);
            this.setSupportsAsync(Boolean.TRUE);
            this.setSupportsUWP(Boolean.TRUE);
        } else if (NET40.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4");
            if (this.additionalProperties.containsKey("supportsAsync")) {
                this.LOGGER.warn(".NET {} generator does not support async.", (Object)NET40);
                this.additionalProperties.remove("supportsAsync");
            }
            this.setTargetFrameworkNuget("net40");
            this.setSupportsAsync(Boolean.FALSE);
        } else if (NET452.equals(this.targetFramework)) {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.5.2-api");
            this.setTargetFrameworkNuget("net452");
            this.setSupportsAsync(Boolean.TRUE);
        } else {
            this.additionalProperties.put(MCS_NET_VERSION_KEY, "4.5.2-api");
            this.setTargetFrameworkNuget("net45");
            this.setSupportsAsync(Boolean.TRUE);
        }
        if (this.additionalProperties.containsKey("generatePropertyChanged")) {
            if (NET35.equals(this.targetFramework)) {
                this.LOGGER.warn("{} is only supported by generated code for .NET 4+.", (Object)"generatePropertyChanged");
                this.additionalProperties.remove("generatePropertyChanged");
            } else if (NETSTANDARD.equals(this.targetFramework)) {
                this.LOGGER.warn("{} is not supported in .NET Standard generated code.", (Object)"generatePropertyChanged");
                this.additionalProperties.remove("generatePropertyChanged");
            } else if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                this.LOGGER.warn("{} is not supported in .NET Core csproj project format.", (Object)"generatePropertyChanged");
                this.additionalProperties.remove("generatePropertyChanged");
            } else {
                this.setGeneratePropertyChanged(this.convertPropertyToBooleanAndWriteBack("generatePropertyChanged"));
            }
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        this.additionalProperties.put("clientPackage", this.clientPackage);
        this.additionalProperties.put("excludeTests", excludeTests);
        this.additionalProperties.put("validatable", this.validatable);
        this.additionalProperties.put("supportsAsync", this.supportsAsync);
        this.additionalProperties.put("supportsUWP", this.supportsUWP);
        this.additionalProperties.put("netStandard", this.netStandard);
        this.additionalProperties.put("targetFrameworkNuget", this.targetFrameworkNuget);
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        } else {
            this.additionalProperties.put("packageGuid", this.packageGuid);
        }
        if (this.additionalProperties.containsKey("optionalMethodArgument")) {
            this.setOptionalMethodArgumentFlag(this.convertPropertyToBooleanAndWriteBack("optionalMethodArgument"));
        } else {
            this.additionalProperties.put("optionalMethodArgument", this.optionalMethodArgumentFlag);
        }
        if (this.additionalProperties.containsKey("optionalAssemblyInfo")) {
            this.setOptionalAssemblyInfoFlag(this.convertPropertyToBooleanAndWriteBack("optionalAssemblyInfo"));
        } else {
            this.additionalProperties.put("optionalAssemblyInfo", this.optionalAssemblyInfoFlag);
        }
        if (this.additionalProperties.containsKey("optionalEmitDefaultValues")) {
            this.setOptionalEmitDefaultValuesFlag(this.convertPropertyToBooleanAndWriteBack("optionalEmitDefaultValues"));
        } else {
            this.additionalProperties.put("optionalEmitDefaultValues", this.optionalEmitDefaultValuesFlag);
        }
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        } else {
            this.additionalProperties.put("nonPublicApi", this.isNonPublicApi());
        }
        String testPackageName = this.testPackageName();
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        String clientPackageDir = packageFolder + File.separator + this.clientPackage;
        String testPackageFolder = this.testFolder + File.separator + testPackageName;
        this.additionalProperties.put("testPackageName", testPackageName);
        int packageDepth = packageFolder.length() - packageFolder.replace(File.separator, "").length();
        String binRelativePath = "..\\";
        for (int i = 0; i < packageDepth; ++i) {
            binRelativePath = binRelativePath + "..\\";
        }
        binRelativePath = binRelativePath + "vendor";
        this.additionalProperties.put("binRelativePath", binRelativePath);
        this.supportingFiles.add(new SupportingFile("IApiAccessor.mustache", clientPackageDir, "IApiAccessor.cs"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("ExceptionFactory.mustache", clientPackageDir, "ExceptionFactory.cs"));
        this.supportingFiles.add(new SupportingFile("OpenAPIDateConverter.mustache", clientPackageDir, "OpenAPIDateConverter.cs"));
        if (NET40.equals(this.targetFramework)) {
            this.supportingFiles.add(new SupportingFile("ReadOnlyDictionary.mustache", clientPackageDir, "ReadOnlyDictionary.cs"));
        }
        if (Boolean.FALSE.equals(this.netStandard) && Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
            this.supportingFiles.add(new SupportingFile("compile.mustache", "", "build.bat"));
            this.supportingFiles.add(new SupportingFile("compile-mono.sh.mustache", "", "build.sh"));
            this.supportingFiles.add(new SupportingFile("packages.config.mustache", packageFolder + File.separator, "packages.config"));
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        } else if (Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
            this.supportingFiles.add(new SupportingFile("project.json.mustache", packageFolder + File.separator, "project.json"));
        }
        this.supportingFiles.add(new SupportingFile("IReadableConfiguration.mustache", clientPackageDir, "IReadableConfiguration.cs"));
        this.supportingFiles.add(new SupportingFile("GlobalConfiguration.mustache", clientPackageDir, "GlobalConfiguration.cs"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("mono_nunit_test.mustache", "", "mono_nunit_test.sh"));
            this.modelTestTemplateFiles.put("model_test.mustache", ".cs");
            this.apiTestTemplateFiles.put("api_test.mustache", ".cs");
            if (Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
                this.supportingFiles.add(new SupportingFile("packages_test.config.mustache", testPackageFolder + File.separator, "packages.config"));
            }
            if (NET40.equals(this.targetFramework)) {
                this.supportingFiles.add(new SupportingFile("JsonSubTypesTests.mustache", testPackageFolder + File.separator + "Client", "JsonSubTypesTests.cs"));
            }
        }
        if (Boolean.TRUE.equals(this.generatePropertyChanged)) {
            this.supportingFiles.add(new SupportingFile("FodyWeavers.xml", packageFolder, "FodyWeavers.xml"));
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.optionalAssemblyInfoFlag && Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
            this.supportingFiles.add(new SupportingFile("AssemblyInfo.mustache", packageFolder + File.separator + "Properties", "AssemblyInfo.cs"));
        }
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
            if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                this.supportingFiles.add(new SupportingFile("netcore_project.mustache", packageFolder, this.packageName + ".csproj"));
            } else {
                this.supportingFiles.add(new SupportingFile("Project.mustache", packageFolder, this.packageName + ".csproj"));
                if (Boolean.FALSE.equals(this.netStandard)) {
                    this.supportingFiles.add(new SupportingFile("nuspec.mustache", packageFolder, this.packageName + ".nuspec"));
                }
            }
            if (Boolean.FALSE.equals(excludeTests)) {
                if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                    this.supportingFiles.add(new SupportingFile("netcore_testproject.mustache", testPackageFolder, testPackageName + ".csproj"));
                } else {
                    this.supportingFiles.add(new SupportingFile("TestProject.mustache", testPackageFolder, testPackageName + ".csproj"));
                }
            }
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "csharp";
    }

    @Override
    public String getHelp() {
        return "Generates a CSharp client library.";
    }

    public void setOptionalAssemblyInfoFlag(boolean flag) {
        this.optionalAssemblyInfoFlag = flag;
    }

    public void setOptionalEmitDefaultValuesFlag(boolean flag) {
        this.optionalEmitDefaultValuesFlag = flag;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Schema parentModel;
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && (parentModel = allDefinitions.get(this.toModelName(codegenModel.parent))) != null) {
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            if (codegenModel.hasEnums) {
                codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
            }
            HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
            for (CodegenProperty property : codegenModel.vars) {
                propertyHash.put(property.name, property);
            }
            for (CodegenProperty property : codegenModel.readWriteVars) {
                if (property.defaultValue != null || parentCodegenModel.discriminator == null || !property.name.equals(parentCodegenModel.discriminator.getPropertyName())) continue;
                property.defaultValue = "\"" + name + "\"";
            }
            CodegenProperty last = null;
            for (CodegenProperty property : parentCodegenModel.vars) {
                if (propertyHash.containsKey(property.name)) continue;
                CodegenProperty parentVar = property.clone();
                parentVar.isInherited = true;
                last = parentVar;
                this.LOGGER.info("adding parent variable {}", (Object)property.name);
                codegenModel.parentVars.add(parentVar);
            }
        }
        if (codegenModel != null && codegenModel.readWriteVars != null && codegenModel.readWriteVars.size() > 1) {
            int length;
            for (int i = length = codegenModel.readWriteVars.size() - 1; i > length / 2; --i) {
                CodegenProperty codegenProperty = codegenModel.readWriteVars.get(i);
                if (codegenModel.readWriteVars.indexOf(codegenProperty) >= i) continue;
                codegenModel.readWriteVars.remove(i);
            }
        }
        return codegenModel;
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
        this.postProcessEmitDefaultValue(parameter.vendorExtensions);
        super.postProcessParameter(parameter);
        if (this.nullableType.contains(parameter.dataType)) {
            if (!parameter.required) {
                parameter.dataType = parameter.dataType + "?";
            } else {
                parameter.vendorExtensions.put("x-csharp-value-type", true);
            }
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
        this.postProcessEmitDefaultValue(property.vendorExtensions);
        super.postProcessModelProperty(model, property);
        if (!property.isContainer && (this.nullableType.contains(property.dataType) || property.isEnum)) {
            property.vendorExtensions.put("x-csharp-value-type", true);
        }
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "'");
            ArrayList<String> modifiers = new ArrayList<String>();
            modifiers.add("CultureInvariant");
            for (char c : pattern.substring(i).toCharArray()) {
                if (this.regexModifiers.containsKey(Character.valueOf(c))) {
                    String modifier = this.regexModifiers.get(Character.valueOf(c));
                    modifiers.add(modifier);
                    continue;
                }
                if (c != 'l') continue;
                modifiers.remove("CultureInvariant");
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    public void postProcessEmitDefaultValue(Map<String, Object> vendorExtensions) {
        vendorExtensions.put("x-emit-default-value", this.optionalEmitDefaultValuesFlag);
    }

    public void setTargetFramework(String dotnetFramework) {
        if (!this.frameworks.containsKey(dotnetFramework)) {
            this.LOGGER.warn("Invalid .NET framework version, defaulting to {}", (Object)this.targetFramework);
        } else {
            this.targetFramework = dotnetFramework;
        }
        switch (this.targetFramework) {
            case "v3.5": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("105.1.0", "net35"));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", "net35"));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", "net35"));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", "net35"));
                break;
            }
            case "v4.0": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("105.1.0", "net4"));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", "net40"));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", "net40"));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", "net40"));
                break;
            }
            case "v4.5": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("105.1.0", "net45"));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", "net45"));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", "net45"));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", "net45"));
                break;
            }
            case "v4.5.2": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("106.10.1", "net452"));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", "net45"));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", "net45"));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", "net45"));
                this.additionalProperties.put("isRestSharp_106_10_1_above", true);
                break;
            }
            case "uwp": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("105.1.0", UWP));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", UWP));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", UWP));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", UWP));
                break;
            }
            case "netstandard1.3": {
                this.additionalProperties.put(RESTSHARP, new LibraryDependency("105.1.0", NETSTANDARD));
                this.additionalProperties.put(JSON_SUBTYPES, new LibraryDependency("1.6.0", NETSTANDARD));
                this.additionalProperties.put(NEWTONSOFT_JSON, new LibraryDependency("12.0.3", NETSTANDARD));
                this.additionalProperties.put(NUNIT, new LibraryDependency("3.11.0", NETSTANDARD));
            }
        }
        this.LOGGER.info("Generating code for .NET Framework {}", (Object)this.targetFramework);
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                if (!parentModelCodegenPropery.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(value) != null) {
            return StringUtils.camelize(this.getSymbolName(value));
        }
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("double") || datatype.startsWith("float")) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("_", " ");
        var = StringUtils.camelize(var);
        if ((var = var.replaceAll("\\W+", "")).matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setTargetFrameworkNuget(String targetFrameworkNuget) {
        this.targetFrameworkNuget = targetFrameworkNuget;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }

    public void setSupportsUWP(Boolean supportsUWP) {
        this.supportsUWP = supportsUWP;
    }

    public void setNetStandard(Boolean netStandard) {
        this.netStandard = netStandard;
    }

    public void setGeneratePropertyChanged(Boolean generatePropertyChanged) {
        this.generatePropertyChanged = generatePropertyChanged;
        if (this.generatePropertyChanged) {
            this.additionalProperties.put(FODY, new LibraryDependency("1.29.4", this.targetFrameworkNuget));
            this.additionalProperties.put(PROPERTYCHANGED_FODY, new LibraryDependency("1.51.3", this.targetFrameworkNuget));
        }
    }

    public void setUseCompareNetObjects(Boolean useCompareNetObjects) {
        this.useCompareNetObjects = useCompareNetObjects;
    }

    public void setCaseInsensitiveResponseHeaders(Boolean caseInsensitiveResponseHeaders) {
        this.caseInsensitiveResponseHeaders = caseInsensitiveResponseHeaders;
    }

    public boolean isNonPublicApi() {
        return this.nonPublicApi;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public void setValidatable(boolean validatable) {
        this.validatable = validatable;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.apiPackage();
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.modelPackage();
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = this.getAdditionalProperties(schema);
            String inner = this.getSchemaType(additionalProperties);
            if (ModelUtils.isMapSchema(additionalProperties)) {
                inner = this.toInstantiationType(additionalProperties);
            }
            return (String)this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return (String)this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    @Override
    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && this.nullableType.contains(type)) {
                return type + "?";
            }
            return type;
        }
        return null;
    }
}

