/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;

public class JavaVertXWebServerCodegen
extends AbstractJavaCodegen {
    protected String resourceFolder = "src/main/resources";
    protected String apiVersion = "1.0.0-SNAPSHOT";

    public JavaVertXWebServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "java-vertx-web";
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
        this.apiTemplateFiles.put("apiHandler.mustache", "Handler.java");
        this.templateDir = "JavaVertXWebServer";
        this.embeddedTemplateDir = "JavaVertXWebServer";
        this.invokerPackage = "org.openapitools.vertxweb.server";
        this.apiPackage = this.invokerPackage + ".api";
        this.modelPackage = this.invokerPackage + ".model";
        this.artifactId = "openapi-java-vertx-web-server";
        this.artifactVersion = this.apiVersion;
        this.setDateLibrary("java8");
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("artifactVersion", this.getArtifactVersion());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.updateOption("invokerPackage", this.invokerPackage);
        this.updateOption("dateLibrary", this.getDateLibrary());
        this.typeMapping.put("file", "FileUpload");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("date", "String");
        this.typeMapping.put("DateTime", "String");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-vertx-web";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Vert.x-Web Server (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiTestTemplateFiles.clear();
        this.importMapping.remove("JsonCreator");
        this.importMapping.remove("com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("FileUpload", "io.vertx.ext.web.FileUpload");
        this.importMapping.put("JsonObject", "io.vertx.core.json.JsonObject");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        String sourcePackageFolder = this.sourceFolder + File.separator + this.invokerPackage.replace(".", File.separator);
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("supportFiles/openapi.mustache", this.resourceFolder, "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("supportFiles/HttpServerVerticle.mustache", sourcePackageFolder, "HttpServerVerticle.java"));
        this.supportingFiles.add(new SupportingFile("supportFiles/ApiResponse.mustache", sourcePackageFolder, "ApiResponse.java"));
        this.supportingFiles.add(new SupportingFile("supportFiles/pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!model.isEnum) {
            model.imports.add("JsonInclude");
            model.imports.add("JsonProperty");
            if (model.hasEnums) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        Map<String, Object> newObjs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)newObjs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                operation.httpMethod = operation.httpMethod.toLowerCase(Locale.ROOT);
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                }
                if (operation.allParams.stream().anyMatch(p -> p.isFormParam && p.isFile)) {
                    operation.allParams = operation.allParams.stream().filter(p -> !p.isFormParam || p.isFile).collect(Collectors.toList());
                    continue;
                }
                if (!operation.allParams.stream().anyMatch(p -> p.isFormParam)) continue;
                CodegenParameter dummyParam = new CodegenParameter();
                dummyParam.isFormParam = true;
                dummyParam.isFile = false;
                dummyParam.dataType = "JsonObject";
                dummyParam.paramName = "formBody";
                operation.allParams = Stream.concat(operation.allParams.stream().filter(p -> !p.isFormParam), Stream.of(dummyParam)).collect(Collectors.toList());
            }
        }
        return newObjs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        return codegenModel;
    }
}

