/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.NugetPackage;
import org.owasp.dependencycheck.data.nuget.NuspecParseException;
import org.owasp.dependencycheck.data.nuget.XPathNuspecParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NuspecAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "dotnet";
    private static final Logger LOGGER = LoggerFactory.getLogger(NuspecAnalyzer.class);
    private static final String ANALYZER_NAME = "Nuspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "nuspec";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("nuspec").build();

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nuspec.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking Nuspec file {}", (Object)dependency);
        try {
            NugetPackage np;
            XPathNuspecParser parser = new XPathNuspecParser();
            try (FileInputStream fis = new FileInputStream(dependency.getActualFilePath());){
                np = parser.parse(fis);
            }
            catch (FileNotFoundException | NuspecParseException ex) {
                throw new AnalysisException(ex);
            }
            dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
            if (np.getOwners() != null) {
                dependency.addEvidence(EvidenceType.VENDOR, SUPPORTED_EXTENSIONS, "owners", np.getOwners(), Confidence.HIGHEST);
            }
            dependency.addEvidence(EvidenceType.VENDOR, SUPPORTED_EXTENSIONS, "authors", np.getAuthors(), Confidence.HIGH);
            dependency.addEvidence(EvidenceType.VERSION, SUPPORTED_EXTENSIONS, "version", np.getVersion(), Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.PRODUCT, SUPPORTED_EXTENSIONS, "id", np.getId(), Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.VENDOR, SUPPORTED_EXTENSIONS, "description", np.getDescription(), Confidence.LOW);
            dependency.addEvidence(EvidenceType.PRODUCT, SUPPORTED_EXTENSIONS, "description", np.getDescription(), Confidence.LOW);
            dependency.setName(np.getId());
            dependency.setVersion(np.getVersion());
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("nuget").withName(np.getId()).withVersion(np.getVersion()).build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for nuspec", (Throwable)ex);
                GenericIdentifier gid = new GenericIdentifier("nuspec:" + np.getId() + "@" + np.getVersion(), Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(gid);
            }
            String packagePath = String.format("%s:%s", np.getId(), np.getVersion());
            dependency.setPackagePath(packagePath);
            dependency.setDisplayFileName(packagePath);
            if (np.getLicenseUrl() != null && !np.getLicenseUrl().isEmpty()) {
                dependency.setLicense(np.getLicenseUrl());
            }
            if (np.getTitle() != null) {
                dependency.addEvidence(EvidenceType.PRODUCT, SUPPORTED_EXTENSIONS, "title", np.getTitle(), Confidence.MEDIUM);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }
}

