/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.Collections;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.assertions.Index;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAssert
extends GroupAssert<List<?>> {
    protected ListAssert(List<?> actual) {
        super(actual);
    }

    public ListAssert contains(Object o, Index index) {
        Object actualElement;
        if (index == null) {
            throw new NullPointerException(this.formattedErrorMessage("The given index should not be null"));
        }
        this.isNotNull().isNotEmpty();
        int indexValue = index.value();
        int listSize = this.actualGroupSize();
        if (indexValue < 0 || indexValue >= listSize) {
            this.failIndexOutOfBounds(indexValue);
        }
        if (!Objects.areEqual(actualElement = ((List)this.actual).get(indexValue), o)) {
            this.failElementNotFound(o, actualElement, indexValue);
        }
        return this;
    }

    private void failElementNotFound(Object e, Object a, int index) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("expecting ", Formatting.inBrackets(e), " at index ", Formatting.inBrackets(index), " but found ", Formatting.inBrackets(a)));
    }

    private void failIndexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException(this.formattedErrorMessage(Strings.concat("The index ", Formatting.inBrackets(index), " should be greater than or equal to zero and less than ", this.actualGroupSize())));
    }

    public ListAssert containsSequence(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        if (sequenceSize == 0) {
            return this;
        }
        int indexOfFirst = ((List)this.actual).indexOf(sequence[0]);
        if (indexOfFirst == -1) {
            this.failIfSequenceNotFound(sequence);
        }
        int listSize = this.actualGroupSize();
        for (int i = 0; i < sequenceSize; ++i) {
            int actualIndex = indexOfFirst + i;
            if (actualIndex > listSize - 1) {
                this.failIfSequenceNotFound(sequence);
            }
            if (Objects.areEqual(sequence[i], ((List)this.actual).get(actualIndex))) continue;
            this.failIfSequenceNotFound(sequence);
        }
        return this;
    }

    private void failIfSequenceNotFound(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("list:", Formatting.inBrackets(this.actual), " does not contain the sequence:", Formatting.inBrackets(notFound)));
    }

    public ListAssert startsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotStartingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotStartingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (Objects.areEqual(sequence[i], ((List)this.actual).get(i))) continue;
            this.failIfNotStartingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotStartingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("list:", Formatting.inBrackets(this.actual), " does not start with the sequence:", Formatting.inBrackets(notFound)));
    }

    public ListAssert endsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotEndingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotEndingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - 1 - i;
            int listIndex = listSize - 1 - i;
            if (Objects.areEqual(sequence[sequenceIndex], ((List)this.actual).get(listIndex))) continue;
            this.failIfNotEndingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotEndingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("list:", Formatting.inBrackets(this.actual), " does not end with the sequence:", Formatting.inBrackets(notFound)));
    }

    public ListAssert contains(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> notFound = this.notFoundInActual(objects);
        if (notFound.isEmpty()) {
            return this;
        }
        throw this.failureIfExpectedElementsNotFound(notFound);
    }

    private Collection<Object> notFoundInActual(Object ... objects) {
        return Collections.notFound((Collection)this.actual, objects);
    }

    public ListAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        ArrayList<Object> copy = new ArrayList<Object>((Collection)this.actual);
        List<Object> notFound = this.notFoundInCopy(copy, objects);
        if (!notFound.isEmpty()) {
            throw this.failureIfExpectedElementsNotFound(notFound);
        }
        if (copy.isEmpty()) {
            return this;
        }
        throw this.failureIfUnexpectedElementsFound(copy);
    }

    private List<Object> notFoundInCopy(List<Object> copy, Object ... objects) {
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object o : objects) {
            if (!copy.contains(o)) {
                notFound.add(o);
                continue;
            }
            copy.remove(o);
        }
        return notFound;
    }

    private AssertionError failureIfExpectedElementsNotFound(Collection<Object> notFound) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat("list:", Formatting.inBrackets(this.actual), " does not contain element(s):", Formatting.inBrackets(notFound)));
    }

    private AssertionError failureIfUnexpectedElementsFound(List<Object> unexpected) {
        this.failIfCustomMessageIsSet();
        return this.failure(Strings.concat("unexpected element(s):", Formatting.inBrackets(unexpected), " in list:", Formatting.inBrackets(this.actual)));
    }

    public ListAssert excludes(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        Collection<Object> found = Collections.found((Collection)this.actual, objects);
        if (found.isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat("list:", Formatting.inBrackets(this.actual), " does not exclude element(s):", Formatting.inBrackets(found)));
    }

    private void validateIsNotNull(Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage("the given array of objects should not be null"));
        }
    }

    public ListAssert doesNotHaveDuplicates() {
        this.isNotNull();
        Collection duplicates = org.fest.util.Collections.duplicatesFrom((Collection)this.actual);
        if (duplicates.isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat("list:", Formatting.inBrackets(this.actual), " contains duplicate(s):", Formatting.inBrackets(duplicates)));
    }

    public ListAssert as(String description) {
        this.description(description);
        return this;
    }

    public ListAssert describedAs(String description) {
        return this.as(description);
    }

    public ListAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ListAssert describedAs(Description description) {
        return this.as(description);
    }

    public ListAssert satisfies(Condition<List<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ListAssert doesNotSatisfy(Condition<List<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ListAssert is(Condition<List<?>> condition) {
        this.assertIs(condition);
        return this;
    }

    public ListAssert isNot(Condition<List<?>> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ListAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat("expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for list:", Formatting.inBrackets(this.actual)));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((List)this.actual).size();
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (org.fest.util.Collections.isEmpty((Collection)this.actual)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("expecting empty list, but was:", Formatting.inBrackets(this.actual)));
    }

    public ListAssert isNotEmpty() {
        this.isNotNull();
        if (!((List)this.actual).isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting a non-empty list, but it was empty");
    }

    @Override
    public void isNullOrEmpty() {
        if (org.fest.util.Collections.isEmpty((Collection)this.actual)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat("expecting a null or empty list, but was:", Formatting.inBrackets(this.actual)));
    }

    public ListAssert isNotNull() {
        if (this.actual != null) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure("expecting a non-null list, but it was null");
    }

    public ListAssert containsExactly(Object ... objects) {
        this.validateIsNotNull(objects);
        return this.isNotNull().isEqualTo(org.fest.util.Collections.list(objects));
    }

    public ListAssert isEqualTo(List<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ListAssert isNotEqualTo(List<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ListAssert isSameAs(List<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ListAssert isNotSameAs(List<?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    public ListAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

