/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

final class ContainerStateValidator {
    @RunsInCurrentThread
    static void validateCanResize(Container c) {
        if (c instanceof JInternalFrame) {
            ContainerStateValidator.validateCanResize((JInternalFrame)c);
            return;
        }
        if (!ContainerStateValidator.isResizable(c)) {
            throw ContainerStateValidator.containerNotResizableFailure(c);
        }
        ComponentStateValidator.validateIsEnabledAndShowing(c);
    }

    @RunsInCurrentThread
    private static void validateCanResize(JInternalFrame internalFrame) {
        ComponentStateValidator.validateIsShowing(internalFrame);
        if (!internalFrame.isResizable()) {
            throw ContainerStateValidator.containerNotResizableFailure(internalFrame);
        }
    }

    @RunsInCurrentThread
    private static boolean isResizable(Container c) {
        if (c instanceof Dialog) {
            return ((Dialog)c).isResizable();
        }
        if (c instanceof Frame) {
            return ((Frame)c).isResizable();
        }
        return false;
    }

    @RunsInCurrentThread
    private static IllegalStateException containerNotResizableFailure(Container c) {
        throw new IllegalStateException(Strings.concat("Expecting component ", Formatting.format(c), " to be resizable by the user"));
    }

    private ContainerStateValidator() {
    }
}

