/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import org.fest.swing.format.ComponentFormatter;
import org.fest.util.Strings;

public abstract class ComponentFormatterTemplate
implements ComponentFormatter {
    public final String format(Component c) {
        this.validateTypeOf(c);
        return this.doFormat(c);
    }

    protected abstract String doFormat(Component var1);

    private void validateTypeOf(Component c) {
        if (c == null) {
            throw new NullPointerException("The component should not be null");
        }
        if (!this.targetType().isAssignableFrom(c.getClass())) {
            throw new IllegalArgumentException(Strings.concat("This formatter only supports components of type ", this.targetType().getName()));
        }
    }
}

