/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.v4_3_1.runner;

import org.fest.swing.junit.runner.FailureScreenshotTaker;
import org.fest.swing.junit.v4_3_1.runner.TestInfo;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.notification.RunNotifier;

class MethodRunner
extends TestMethodRunner {
    private final TestInfo testInfo;
    private final FailureScreenshotTaker screenshotTaker;

    public MethodRunner(TestInfo testInfo, RunNotifier notifier, FailureScreenshotTaker screenshotTaker) {
        super(testInfo.test(), testInfo.method(), notifier, testInfo.description());
        this.testInfo = testInfo;
        this.screenshotTaker = screenshotTaker;
    }

    protected void addFailure(Throwable e) {
        if (this.testInfo.isGUITest()) {
            this.saveScreenshot();
        }
        super.addFailure(e);
    }

    private void saveScreenshot() {
        this.screenshotTaker.saveScreenshot(this.testInfo.screenshotFileName());
    }
}

