/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;

public class CommandToggleButtonGroup
implements Serializable {
    protected Vector<JCommandToggleButton> buttons = new Vector();
    protected Map<JCommandToggleButton, ChangeListener> modelChangeListeners = new HashMap<JCommandToggleButton, ChangeListener>();
    private PropertyChangeSupport changeSupport;
    public static final String SELECTED_PROPERTY = "selected";
    protected JCommandToggleButton selection;
    protected boolean allowsClearingSelection = true;

    public void setAllowsClearingSelection(boolean allowsClearingSelection) {
        this.allowsClearingSelection = allowsClearingSelection;
    }

    public boolean isAllowsClearingSelection() {
        return this.allowsClearingSelection;
    }

    public void add(final JCommandToggleButton b) {
        boolean wasSelectionNull;
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        boolean bl = wasSelectionNull = this.selection == null;
        if (b.getActionModel().isSelected()) {
            if (wasSelectionNull) {
                this.selection = b;
            } else {
                b.getActionModel().setSelected(false);
            }
        }
        ChangeListener cl = new ChangeListener(){
            boolean wasSelected;
            {
                this.wasSelected = jCommandToggleButton.getActionModel().isSelected();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = b.getActionModel().isSelected();
                if (this.wasSelected != isSelected) {
                    CommandToggleButtonGroup.this.setSelected(b, isSelected);
                }
                this.wasSelected = isSelected;
            }
        };
        b.getActionModel().addChangeListener(cl);
        this.modelChangeListeners.put(b, cl);
        if (wasSelectionNull) {
            this.firePropertyChange(SELECTED_PROPERTY, null, b);
        }
    }

    public void remove(JCommandToggleButton b) {
        boolean wasSelected;
        if (b == null) {
            return;
        }
        this.buttons.removeElement(b);
        boolean bl = wasSelected = b == this.selection;
        if (wasSelected) {
            this.selection = null;
        }
        b.getActionModel().removeChangeListener(this.modelChangeListeners.get(b));
        this.modelChangeListeners.remove(b);
        if (wasSelected) {
            this.firePropertyChange(SELECTED_PROPERTY, b, null);
        }
    }

    public void setSelected(JCommandToggleButton button, boolean isSelected) {
        if (isSelected && button != null && button != this.selection) {
            JCommandToggleButton oldSelection = this.selection;
            this.selection = button;
            if (oldSelection != null) {
                oldSelection.getActionModel().setSelected(false);
            }
            button.getActionModel().setSelected(true);
            this.firePropertyChange(SELECTED_PROPERTY, oldSelection, button);
        }
        if (!isSelected && button != null && button == this.selection) {
            if (this.allowsClearingSelection) {
                this.selection = null;
                button.getActionModel().setSelected(false);
                this.firePropertyChange(SELECTED_PROPERTY, button, null);
            } else {
                button.getActionModel().setSelected(true);
            }
        }
    }

    public JCommandToggleButton getSelected() {
        return this.selection;
    }

    public void clearSelection() {
        if (this.allowsClearingSelection && this.selection != null) {
            this.selection.getActionModel().setSelected(false);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null || oldValue == newValue) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

