/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelSwitcher {
    public static JComboBox getLookAndFeelSwitcher(final JFrame frame) {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        LookAndFeelInfoObj[] lafObjs = new LookAndFeelInfoObj[lafs.length];
        int i = 0;
        while (i < lafs.length) {
            lafObjs[i] = new LookAndFeelInfoObj(lafs[i], lafs[i].getName());
            ++i;
        }
        final JComboBox<LookAndFeelInfoObj> result = new JComboBox<LookAndFeelInfoObj>(lafObjs);
        int i2 = 0;
        while (i2 < lafs.length) {
            if (lafs[i2].getName().equals(UIManager.getLookAndFeel().getName())) {
                result.setSelectedIndex(i2);
                break;
            }
            ++i2;
        }
        result.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasDecoratedByOS = !frame.isUndecorated();
                        try {
                            LookAndFeelInfoObj selected = (LookAndFeelInfoObj)result.getSelectedItem();
                            UIManager.setLookAndFeel(selected.lafInfo.getClassName());
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                        boolean canBeDecoratedByLAF = UIManager.getLookAndFeel().getSupportsWindowDecorations();
                        if (canBeDecoratedByLAF == wasDecoratedByOS) {
                            boolean wasVisible = frame.isVisible();
                            frame.setVisible(false);
                            frame.dispose();
                            if (!canBeDecoratedByLAF) {
                                frame.setUndecorated(false);
                                frame.getRootPane().setWindowDecorationStyle(0);
                            } else {
                                frame.setUndecorated(true);
                                frame.getRootPane().setWindowDecorationStyle(1);
                            }
                            frame.setVisible(wasVisible);
                            wasDecoratedByOS = !frame.isUndecorated();
                        }
                    }
                });
            }
        });
        return result;
    }

    public static interface LocaleCallback {
        public void onLocaleSelected(Locale var1);
    }

    static class LookAndFeelInfoObj {
        UIManager.LookAndFeelInfo lafInfo;
        String displayName;

        public LookAndFeelInfoObj(UIManager.LookAndFeelInfo lafInfo, String displayName) {
            this.lafInfo = lafInfo;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

