/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import test.common.LocaleSwitcher;

public class TestColorSelector
extends JFrame {
    Color bColor;
    protected ResourceBundle resourceBundle;
    protected Locale currLocale;
    protected JPanel centerPanel;

    public TestColorSelector() {
        JPanel top = new JPanel(new FlowLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
        this.centerPanel = new JPanel();
        this.bColor = this.centerPanel.getBackground();
        this.add((Component)top, "North");
        this.add((Component)this.centerPanel, "Center");
        final JCheckBox hasTheme = new JCheckBox("theme");
        hasTheme.setSelected(true);
        final JCheckBox hasStandard = new JCheckBox("standard");
        hasStandard.setSelected(true);
        final JCheckBox hasRecent = new JCheckBox("recent");
        hasRecent.setSelected(true);
        final ColorIcon colorIcon = new ColorIcon(this.bColor);
        JCommandButton jcb = new JCommandButton(colorIcon);
        jcb.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        jcb.setDisplayState(CommandButtonDisplayState.SMALL);
        jcb.setFlat(false);
        final JColorSelectorPopupMenu.ColorSelectorCallback callback = new JColorSelectorPopupMenu.ColorSelectorCallback(){

            @Override
            public void onColorSelected(Color color) {
                TestColorSelector.this.bColor = color;
                TestColorSelector.this.centerPanel.setBackground(TestColorSelector.this.bColor);
                colorIcon.setColor(TestColorSelector.this.bColor);
            }

            @Override
            public void onColorRollover(Color color) {
                if (color != null) {
                    TestColorSelector.this.centerPanel.setBackground(color);
                } else {
                    TestColorSelector.this.centerPanel.setBackground(TestColorSelector.this.bColor);
                    colorIcon.setColor(TestColorSelector.this.bColor);
                }
            }
        };
        final Color defaultPanelColor = this.centerPanel.getBackground();
        jcb.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JColorSelectorPopupMenu result = new JColorSelectorPopupMenu(callback);
                final JCommandMenuButton automaticColor = new JCommandMenuButton(TestColorSelector.this.resourceBundle.getString("ColorSelector.textAutomatic"), new ColorIcon(defaultPanelColor));
                automaticColor.getActionModel().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        callback.onColorSelected(defaultPanelColor);
                        JColorSelectorPopupMenu.addColorToRecentlyUsed(defaultPanelColor);
                    }
                });
                automaticColor.getActionModel().addChangeListener(new ChangeListener(){
                    boolean wasRollover;
                    {
                        this.wasRollover = jCommandMenuButton.getActionModel().isRollover();
                    }

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        boolean isRollover = automaticColor.getActionModel().isRollover();
                        if (this.wasRollover && !isRollover) {
                            callback.onColorRollover(null);
                        }
                        if (!this.wasRollover && isRollover) {
                            callback.onColorRollover(Color.black);
                        }
                        this.wasRollover = isRollover;
                    }
                });
                result.addMenuButton(automaticColor);
                if (hasTheme.isSelected()) {
                    result.addColorSectionWithDerived(TestColorSelector.this.resourceBundle.getString("ColorSelector.textThemeCaption"), new Color[]{new Color(255, 255, 255), new Color(0, 0, 0), new Color(160, 160, 160), new Color(16, 64, 128), new Color(80, 128, 192), new Color(180, 80, 80), new Color(160, 192, 80), new Color(128, 92, 160), new Color(80, 160, 208), new Color(255, 144, 64)});
                }
                if (hasStandard.isSelected()) {
                    result.addColorSection(TestColorSelector.this.resourceBundle.getString("ColorSelector.textStandardCaption"), new Color[]{new Color(140, 0, 0), new Color(253, 0, 0), new Color(255, 160, 0), new Color(255, 255, 0), new Color(144, 240, 144), new Color(0, 128, 0), new Color(160, 224, 224), new Color(0, 0, 255), new Color(0, 0, 128), new Color(128, 0, 128)});
                }
                if (hasRecent.isSelected()) {
                    result.addRecentSection(TestColorSelector.this.resourceBundle.getString("ColorSelector.textRecentCaption"));
                }
                JCommandMenuButton moreButton = new JCommandMenuButton(TestColorSelector.this.resourceBundle.getString("ColorSelector.textMoreColor"), null);
                moreButton.getActionModel().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Color color = JColorChooser.showDialog(TestColorSelector.this, "Color chooser", ((this).this).TestColorSelector.this.bColor);
                                if (color != null) {
                                    callback.onColorSelected(color);
                                    JColorSelectorPopupMenu.addColorToRecentlyUsed(color);
                                }
                            }
                        });
                    }
                });
                result.addMenuButton(moreButton);
                return result;
            }
        });
        top.add(jcb);
        top.add(hasTheme);
        top.add(hasStandard);
        top.add(hasRecent);
        JComboBox localeSwitcher = LocaleSwitcher.getLocaleSwitcher(new LocaleSwitcher.LocaleCallback(){

            @Override
            public void onLocaleSelected(Locale selected) {
                TestColorSelector.this.currLocale = selected;
                TestColorSelector.this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", TestColorSelector.this.currLocale);
                TestColorSelector.this.applyComponentOrientation(ComponentOrientation.getOrientation(selected));
                SwingUtilities.updateComponentTreeUI(TestColorSelector.this);
            }
        });
        top.add(localeSwitcher);
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new TestColorSelector().setVisible(true);
            }
        });
    }

    protected static class ColorIcon
    implements ResizableIcon {
        int w;
        int h;
        Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.w, this.h);
            g.setColor(this.color.darker());
            g.drawRect(x, y, this.w - 1, this.h - 1);
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public void setDimension(Dimension newDimension) {
            this.w = newDimension.width;
            this.h = newDimension.height;
        }
    }
}

