/*
 * Decompiled with CFR 0.152.
 */
package test.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.IcoWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IcoViewer
extends JFrame {
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();
    private AbstractFileViewPanel fileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;

    public IcoViewer() {
        super("ICO Viewer");
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = IcoViewer.this.bar.getModel().getItems();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + ((File)item.getData()).getAbsolutePath());
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() {
                                    return IcoViewer.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        IcoViewer.this.fileViewPanel.setFolder((List)this.get());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 32;
        this.fileViewPanel = new AbstractFileViewPanel<File>(32, null){

            @Override
            protected void configureCommandButton(AbstractFileViewPanel.Leaf leaf, JCommandButton button, ResizableIcon icon) {
            }

            @Override
            protected InputStream getLeafContent(File leaf) {
                try {
                    return new FileInputStream(leaf);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }

            @Override
            protected ResizableIcon getResizableIcon(AbstractFileViewPanel.Leaf leaf, InputStream stream, CommandButtonDisplayState state, Dimension dimension) {
                int prefSize = state.getPreferredIconSize();
                if (prefSize > 0) {
                    dimension = new Dimension(prefSize, prefSize);
                }
                return IcoWrapperResizableIcon.getIcon(stream, dimension);
            }

            @Override
            protected boolean toShowFile(StringValuePair<File> pair) {
                String name = ((String)pair.getKey()).toLowerCase();
                return name.endsWith(".ico");
            }
        };
        JScrollPane jsp = new JScrollPane(this.fileViewPanel, 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(16);
        this.iconSizeSlider.setMaximum(256);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(64);
        this.iconSizeSlider.setMinorTickSpacing(16);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newValue;
                if (!IcoViewer.this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = IcoViewer.this.iconSizeSlider.getValue()) != IcoViewer.this.currIconSize) {
                    IcoViewer.this.currIconSize = newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IcoViewer.this.fileViewPanel.setIconDimension(IcoViewer.this.currIconSize);
                            IcoViewer.this.invalidate();
                            IcoViewer.this.doLayout();
                        }
                    });
                }
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
    }

    public static void main(String ... args) {
        IcoViewer test = new IcoViewer();
        test.setSize(800, 650);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
        test.setDefaultCloseOperation(2);
    }
}

