/*
 * Decompiled with CFR 0.152.
 */
package test.svg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import test.svg.SvgFileViewPanel;

public class SvgViewer
extends JFrame {
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();
    private SvgFileViewPanel svgFileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;
    protected static FileSystemView fsv = FileSystemView.getFileSystemView();

    public SvgViewer() {
        super("SVG File Viewer");
        this.bar.getModel().addPathListener(new BreadcrumbPathListener(){

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final List newPath = SvgViewer.this.bar.getModel().getItems();
                        SvgViewer.this.svgFileViewPanel.cancelMainWorker();
                        System.out.println("New path is ");
                        for (BreadcrumbItem item : newPath) {
                            System.out.println("\t" + FileSystemView.getFileSystemView().getSystemDisplayName((File)item.getData()));
                        }
                        if (newPath.size() > 0) {
                            SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                                @Override
                                protected List<StringValuePair<File>> doInBackground() {
                                    return SvgViewer.this.bar.getCallback().getLeafs(newPath);
                                }

                                @Override
                                protected void done() {
                                    try {
                                        SvgViewer.this.svgFileViewPanel.setFolder((List)this.get());
                                        SvgViewer.this.svgFileViewPanel.setIconDimension(SvgViewer.this.currIconSize);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                });
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 32;
        this.svgFileViewPanel = new SvgFileViewPanel(this.bar.getCallback(), initialSize);
        JScrollPane jsp = new JScrollPane(this.svgFileViewPanel, 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(16);
        this.iconSizeSlider.setMaximum(128);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(32);
        this.iconSizeSlider.setMinorTickSpacing(8);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int newValue;
                if (!SvgViewer.this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = SvgViewer.this.iconSizeSlider.getValue()) != SvgViewer.this.currIconSize) {
                    SvgViewer.this.currIconSize = newValue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SvgViewer.this.svgFileViewPanel.setIconDimension(SvgViewer.this.currIconSize);
                        }
                    });
                }
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
        JMenuBar jmb = new JMenuBar();
        JMenu menu = new JMenu("Look-and-feel");
        menu.add(LafChanger.getMenuItem(this, "Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Windows Classic", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        menu.add(LafChanger.getMenuItem(this, "Substance", "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel"));
        jmb.add(menu);
        this.setJMenuBar(jmb);
    }

    public static void main(String ... args) {
        SvgViewer test = new SvgViewer();
        test.setSize(550, 385);
        test.setLocationRelativeTo(null);
        test.setVisible(true);
        test.setDefaultCloseOperation(3);
    }

    private static class LafChanger
    implements ActionListener {
        private JFrame frame;
        private String lafClassName;

        public static JMenuItem getMenuItem(JFrame frame, String lafName, String lafClassName) {
            JMenuItem result = new JMenuItem(lafName);
            result.addActionListener(new LafChanger(frame, lafClassName));
            return result;
        }

        public LafChanger(JFrame frame, String lafClassName) {
            this.frame = frame;
            this.lafClassName = lafClassName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean was_wm_decorated = !LafChanger.this.frame.isUndecorated();
                    try {
                        UIManager.setLookAndFeel(LafChanger.this.lafClassName);
                        SwingUtilities.updateComponentTreeUI(LafChanger.this.frame);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
    }
}

