/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import org.fest.assertions.Assertions;
import org.fest.swing.awt.AWT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;

public class CommandToggleButtonTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    int count;
    JCommandToggleButton button;

    @Override
    @Before
    public void onSetUp() {
        URL resource = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-paste.svg");
        Assertions.assertThat(resource).isNotNull();
        final SvgBatikResizableIcon icon = SvgBatikResizableIcon.getSvgIcon(resource, new Dimension(32, 32));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)icon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.buttonFrame = new JFrame();
                CommandToggleButtonTestCase.this.buttonFrame.setLayout(new FlowLayout());
                CommandToggleButtonTestCase.this.button = new JCommandToggleButton("test", icon);
                CommandToggleButtonTestCase.this.button.setDisplayState(CommandButtonDisplayState.BIG);
                CommandToggleButtonTestCase.this.buttonFrame.add(CommandToggleButtonTestCase.this.button);
                CommandToggleButtonTestCase.this.buttonFrame.setSize(300, 200);
                CommandToggleButtonTestCase.this.buttonFrame.setLocationRelativeTo(null);
                CommandToggleButtonTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                CommandToggleButtonTestCase.this.buttonFrame.setVisible(true);
                CommandToggleButtonTestCase.this.count = 0;
                CommandToggleButtonTestCase.this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ++(this).CommandToggleButtonTestCase.this.count;
                    }
                });
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = CommandToggleButtonTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                CommandToggleButtonTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void sanityCheck() {
        String buttonText = GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getText();
            }
        });
        Assertions.assertThat(buttonText).isEqualTo("test");
    }

    @Test
    public void activateButtonWithMouse() {
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isTrue();
    }

    @Test
    public void activateButtonWithSpace() {
        this.robot().moveMouse(this.button);
        this.robot().pressAndReleaseKeys(32);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isTrue();
    }

    @Test
    public void activateButtonWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.doActionClick();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void selectButtonWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isTrue();
    }

    @Test
    public void fireActionOnPress() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.getActionModel().setFireActionOnPress(false);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isFireActionOnPress();
            }
        })).isFalse();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isFalse();
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isTrue();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.getActionModel().setFireActionOnPress(true);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isFireActionOnPress();
            }
        })).isTrue();
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(2);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isFalse();
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(2);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void pressButtonAndDisableBeforeRelease() {
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.getActionModel().setEnabled(false);
            }
        });
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void pressButtonAndMoveAwayBeforeRelease() {
        this.robot().pressMouse(this.button, AWT.centerOf(this.button));
        this.robot().waitForIdle();
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void changeText() {
        String buttonText = GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getText();
            }
        });
        Assertions.assertThat(buttonText).isEqualTo("test");
        String newText = "New text";
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.setText("New text");
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() throws Throwable {
                return CommandToggleButtonTestCase.this.button.getText();
            }
        })).isEqualTo("New text");
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void changeIcon() {
        Dimension iconDimension = GuiActionRunner.execute(new GuiQuery<Dimension>(){

            @Override
            protected Dimension executeInEDT() throws Throwable {
                ResizableIcon icon = CommandToggleButtonTestCase.this.button.getIcon();
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
        });
        URL cutIconUrl = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonTestCase.this.button.setIcon(cutIcon);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Dimension>(){

            @Override
            protected Dimension executeInEDT() throws Throwable {
                ResizableIcon icon = CommandToggleButtonTestCase.this.button.getIcon();
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
        })).isEqualTo(iconDimension);
        this.robot().click(this.button);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }
}

