/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import org.fest.assertions.Assertions;
import org.fest.swing.awt.AWT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;

public class SplitCommandButtonTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    JCommandButton button;
    StringBuffer stringBuffer;
    JCommandMenuButton[] menuButtons;
    static final int MENU_BUTTON_COUNT = 5;
    int count;

    @Override
    @Before
    public void onSetUp() {
        URL resource = SplitCommandButtonTestCase.class.getClassLoader().getResource("utest/common/edit-paste.svg");
        Assertions.assertThat(resource).isNotNull();
        final SvgBatikResizableIcon icon = SvgBatikResizableIcon.getSvgIcon(resource, new Dimension(32, 32));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)icon)).isLoading();
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.stringBuffer = new StringBuffer();
                SplitCommandButtonTestCase.this.count = 0;
                SplitCommandButtonTestCase.this.buttonFrame = new JFrame();
                SplitCommandButtonTestCase.this.button = new JCommandButton("test", icon);
                SplitCommandButtonTestCase.this.button.setDisplayState(CommandButtonDisplayState.BIG);
                SplitCommandButtonTestCase.this.button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                SplitCommandButtonTestCase.this.button.setPopupCallback(new PopupPanelCallback(){

                    @Override
                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        JCommandPopupMenu result = new JCommandPopupMenu();
                        (this).SplitCommandButtonTestCase.this.menuButtons = new JCommandMenuButton[5];
                        int i = 0;
                        while (i < 5) {
                            final int index = i;
                            (this).SplitCommandButtonTestCase.this.menuButtons[i] = new JCommandMenuButton("popup " + i, new EmptyResizableIcon(16));
                            (this).SplitCommandButtonTestCase.this.menuButtons[i].addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ((this).this).SplitCommandButtonTestCase.this.stringBuffer.append(index);
                                }
                            });
                            result.addMenuButton((this).SplitCommandButtonTestCase.this.menuButtons[i]);
                            ++i;
                        }
                        return result;
                    }
                });
                SplitCommandButtonTestCase.this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ++(this).SplitCommandButtonTestCase.this.count;
                    }
                });
                SplitCommandButtonTestCase.this.buttonFrame.setLayout(new FlowLayout());
                SplitCommandButtonTestCase.this.buttonFrame.add(SplitCommandButtonTestCase.this.button);
                SplitCommandButtonTestCase.this.buttonFrame.setSize(300, 200);
                SplitCommandButtonTestCase.this.buttonFrame.setLocationRelativeTo(null);
                SplitCommandButtonTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                SplitCommandButtonTestCase.this.buttonFrame.setVisible(true);
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = SplitCommandButtonTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                SplitCommandButtonTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void activateActionWithMouse() {
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
    }

    @Test
    public void activateActionWithSpace() {
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        Assertions.assertThat(actionClickArea).isNotNull();
        this.robot().moveMouse(this.button, AWT.centerOf(actionClickArea));
        this.robot().pressAndReleaseKeys(32);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
    }

    @Test
    public void activateActionWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.doActionClick();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
    }

    @Test
    public void activatePopupWithMouse() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        Assertions.assertThat(popupClickArea).isNotNull();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void activatePopupWithAPI() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.doPopupClick();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
    }

    @Test
    public void dismissPopupByClickingOutsideTheButton() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        this.robot().click((Component)this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void dismissPopupByClickingTheButton() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        Assertions.assertThat(popupClickArea).isNotNull();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void clickTheFirstMenuButton() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        Assertions.assertThat(popupClickArea).isNotNull();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.menuButtons[0].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("0");
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void clickTheFirstAndSecondMenuButton() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        Assertions.assertThat(popupClickArea).isNotNull();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.menuButtons[0].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("0");
        Assertions.assertThat(this.count).isEqualTo(0);
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.menuButtons[1].isVisible();
            }
        })).isTrue();
        this.robot().click(this.menuButtons[1]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo("01");
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void clickAllMenuButtons() {
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        Assertions.assertThat(popupClickArea).isNotNull();
        int i = 0;
        while (i < 5) {
            this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
            this.robot().waitForIdle();
            final int index = i;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return SplitCommandButtonTestCase.this.menuButtons[index].isVisible();
                }
            })).isTrue();
            this.robot().click(this.menuButtons[i]);
            this.robot().waitForIdle();
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
                }
            })).isFalse();
            ++i;
        }
        String expected = "";
        int i2 = 0;
        while (i2 < 5) {
            expected = String.valueOf(expected) + i2;
            ++i2;
        }
        Assertions.assertThat(this.stringBuffer.toString()).isEqualTo(expected);
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void checkPopupDisable() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getPopupModel().setEnabled(false);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isFalse();
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getPopupModel().setEnabled(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isTrue();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void checkActionDisable() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getActionModel().setEnabled(false);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getActionModel().isEnabled();
            }
        })).isFalse();
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getActionModel().setEnabled(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getActionModel().isEnabled();
            }
        })).isTrue();
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
    }

    @Test
    public void checkActionAndPopupDisable() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getActionModel().setEnabled(false);
                SplitCommandButtonTestCase.this.button.getPopupModel().setEnabled(false);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getActionModel().isEnabled();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isFalse();
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        Rectangle popupClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().popupClickArea;
            }
        });
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getActionModel().setEnabled(true);
                SplitCommandButtonTestCase.this.button.getPopupModel().setEnabled(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getActionModel().isEnabled();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isEnabled();
            }
        })).isTrue();
        this.robot().click((Component)this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isFalse();
        this.robot().click((Component)this.button, AWT.centerOf(popupClickArea));
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getPopupModel().isPopupShowing();
            }
        })).isTrue();
    }

    @Test
    public void pressButtonAndDisableBeforeRelease() {
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        Assertions.assertThat(actionClickArea).isNotNull();
        this.robot().pressMouse(this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SplitCommandButtonTestCase.this.button.getActionModel().setEnabled(false);
            }
        });
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
    }

    @Test
    public void pressButtonAndMoveAwayBeforeRelease() {
        Rectangle actionClickArea = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return SplitCommandButtonTestCase.this.button.getUI().getLayoutInfo().actionClickArea;
            }
        });
        Assertions.assertThat(actionClickArea).isNotNull();
        this.robot().pressMouse(this.button, AWT.centerOf(actionClickArea));
        this.robot().waitForIdle();
        this.robot().moveMouse(this.button, new Point(-10, 10));
        this.robot().waitForIdle();
        this.robot().releaseMouseButtons();
        this.robot().waitForIdle();
        Assertions.assertThat(this.count).isEqualTo(0);
    }
}

