/*
 * Decompiled with CFR 0.152.
 */
package utest.ribbon;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;

public class RibbonBandExpandActionListenerTestCase
extends FestSwingJUnitTestCase {
    JRibbonFrame ribbonFrame;
    JRibbonBand ribbonBand1;
    JRibbonBand ribbonBand2;
    int count1;
    int count2;

    private static JRibbonBand getSampleRibbonBand(ActionListener expandActionListener) {
        JRibbonBand clipboardBand = new JRibbonBand("Clipboard", new edit_paste(), expandActionListener);
        JCommandButton mainButton = new JCommandButton("Paste", new edit_paste());
        mainButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        clipboardBand.addCommandButton(mainButton, RibbonElementPriority.TOP);
        JCommandButton cutButton = new JCommandButton("Cut", new edit_cut());
        cutButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        clipboardBand.addCommandButton(cutButton, RibbonElementPriority.MEDIUM);
        JCommandButton copyButton = new JCommandButton("Copy", new edit_copy());
        copyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        clipboardBand.addCommandButton(copyButton, RibbonElementPriority.MEDIUM);
        JCommandButton formatButton = new JCommandButton("Format", new edit_paste());
        formatButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        clipboardBand.addCommandButton(formatButton, RibbonElementPriority.MEDIUM);
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)clipboardBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)clipboardBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)clipboardBand.getControlPanel()));
        clipboardBand.setResizePolicies(resizePolicies);
        return clipboardBand;
    }

    @Override
    protected void onSetUp() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandExpandActionListenerTestCase.this.count1 = 0;
                RibbonBandExpandActionListenerTestCase.this.count2 = 0;
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame = new JRibbonFrame();
                RibbonBandExpandActionListenerTestCase.this.ribbonBand1 = RibbonBandExpandActionListenerTestCase.getSampleRibbonBand(null);
                RibbonBandExpandActionListenerTestCase.this.ribbonBand2 = RibbonBandExpandActionListenerTestCase.getSampleRibbonBand(new ExpandActionListener1());
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.getRibbon().addTask(new RibbonTask("Task", RibbonBandExpandActionListenerTestCase.this.ribbonBand1, RibbonBandExpandActionListenerTestCase.this.ribbonBand2));
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.setPreferredSize(new Dimension(r.width, r.height / 2));
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.pack();
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.setLocation(r.x, r.y);
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.setVisible(true);
                RibbonBandExpandActionListenerTestCase.this.ribbonFrame.setDefaultCloseOperation(2);
            }
        });
    }

    @Test
    public void testDefaultActionListeners() {
        AbstractCommandButton expandButton1 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand1.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton1).isNull();
        AbstractCommandButton expandButton2 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand2.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton2).isNotNull();
        this.robot().click(expandButton2);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count1).isEqualTo(1);
        Assertions.assertThat(this.count2).isZero();
    }

    @Test
    public void testSwitchFromNoListener() {
        AbstractCommandButton expandButton1 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand1.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton1).isNull();
        Assertions.assertThat(this.count1).isZero();
        Assertions.assertThat(this.count2).isZero();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandExpandActionListenerTestCase.this.ribbonBand1.setExpandActionListener(new ExpandActionListener1());
            }
        });
        this.robot().waitForIdle();
        expandButton1 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand1.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton1).isNotNull();
        this.robot().click(expandButton1);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count1).isEqualTo(1);
        Assertions.assertThat(this.count2).isZero();
    }

    @Test
    public void testSwitchToNoListener() {
        AbstractCommandButton expandButton2 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand2.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton2).isNotNull();
        Assertions.assertThat(this.count1).isZero();
        Assertions.assertThat(this.count2).isZero();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandExpandActionListenerTestCase.this.ribbonBand2.setExpandActionListener(null);
            }
        });
        this.robot().waitForIdle();
        expandButton2 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand2.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton2).isNull();
    }

    @Test
    public void testSwitchToAnotherListener() {
        AbstractCommandButton expandButton2 = GuiActionRunner.execute(new GuiQuery<AbstractCommandButton>(){

            @Override
            protected AbstractCommandButton executeInEDT() throws Throwable {
                return ((BasicRibbonBandUI)RibbonBandExpandActionListenerTestCase.this.ribbonBand2.getUI()).getExpandButton();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(expandButton2).isNotNull();
        Assertions.assertThat(this.count1).isZero();
        Assertions.assertThat(this.count2).isZero();
        this.robot().click(expandButton2);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count1).isEqualTo(1);
        Assertions.assertThat(this.count2).isZero();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                RibbonBandExpandActionListenerTestCase.this.ribbonBand2.setExpandActionListener(new ExpandActionListener2());
            }
        });
        this.robot().waitForIdle();
        this.robot().click(expandButton2);
        this.robot().waitForIdle();
        Assertions.assertThat(this.count1).isEqualTo(1);
        Assertions.assertThat(this.count2).isEqualTo(1);
    }

    private class ExpandActionListener1
    implements ActionListener {
        private ExpandActionListener1() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++RibbonBandExpandActionListenerTestCase.this.count1;
        }
    }

    private class ExpandActionListener2
    implements ActionListener {
        private ExpandActionListener2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++RibbonBandExpandActionListenerTestCase.this.count2;
        }
    }
}

