/*
 * Decompiled with CFR 0.152.
 */
package utest.ribbon;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class RibbonBandLayoutTestCase
extends FestSwingJUnitTestCase {
    private JCommandToggleButton findButton;
    private JCommandToggleButton replaceButton;
    private JCommandToggleButton findReplaceButton;
    private JCommandToggleButton selectAllButton;

    @Override
    protected void onSetUp() {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                JRibbonFrame frame = new JRibbonFrame();
                JRibbonBand findBand = new JRibbonBand("Find", new EmptyResizableIcon(32));
                findBand.setCollapsedStateKeyTip("ZY");
                RibbonBandLayoutTestCase.this.findButton = new JCommandToggleButton("Find", new EmptyResizableIcon(32));
                RibbonBandLayoutTestCase.this.findButton.getActionModel().setSelected(true);
                findBand.addCommandButton(RibbonBandLayoutTestCase.this.findButton, RibbonElementPriority.TOP);
                RibbonBandLayoutTestCase.this.replaceButton = new JCommandToggleButton("Replace", new EmptyResizableIcon(32));
                RibbonBandLayoutTestCase.this.replaceButton.getActionModel().setSelected(true);
                findBand.addCommandButton(RibbonBandLayoutTestCase.this.replaceButton, RibbonElementPriority.MEDIUM);
                RibbonBandLayoutTestCase.this.findReplaceButton = new JCommandToggleButton("Find replace", new EmptyResizableIcon(32));
                RibbonBandLayoutTestCase.this.findReplaceButton.getActionModel().setSelected(true);
                findBand.addCommandButton(RibbonBandLayoutTestCase.this.findReplaceButton, RibbonElementPriority.MEDIUM);
                RibbonBandLayoutTestCase.this.selectAllButton = new JCommandToggleButton("Select all", new EmptyResizableIcon(32));
                RibbonBandLayoutTestCase.this.selectAllButton.getActionModel().setSelected(true);
                findBand.addCommandButton(RibbonBandLayoutTestCase.this.selectAllButton, RibbonElementPriority.MEDIUM);
                ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
                resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)findBand.getControlPanel()));
                resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)findBand.getControlPanel()));
                findBand.setResizePolicies(resizePolicies);
                frame.getRibbon().addTask(new RibbonTask("Find", findBand));
                frame.setSize(600, 300);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }

    @Test
    public void testLayout() {
        Dimension parentDimension = GuiActionRunner.execute(new GuiQuery<Dimension>(){

            @Override
            protected Dimension executeInEDT() throws Throwable {
                return RibbonBandLayoutTestCase.this.findButton.getParent().getSize();
            }
        });
        Rectangle findRect = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return RibbonBandLayoutTestCase.this.findButton.getBounds();
            }
        });
        Rectangle replaceRect = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return RibbonBandLayoutTestCase.this.replaceButton.getBounds();
            }
        });
        Rectangle findReplaceRect = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return RibbonBandLayoutTestCase.this.findReplaceButton.getBounds();
            }
        });
        Rectangle selectAllRect = GuiActionRunner.execute(new GuiQuery<Rectangle>(){

            @Override
            protected Rectangle executeInEDT() throws Throwable {
                return RibbonBandLayoutTestCase.this.selectAllButton.getBounds();
            }
        });
        Assertions.assertThat(findRect.x).isEqualTo(parentDimension.width - findReplaceRect.x - findReplaceRect.width);
        Assertions.assertThat(findReplaceRect.y - replaceRect.y - replaceRect.height).isEqualTo(selectAllRect.y - findReplaceRect.y - findReplaceRect.height);
        Assertions.assertThat(findRect.y).isEqualTo(replaceRect.y);
        Assertions.assertThat(findRect.y + findRect.height).isEqualTo(selectAllRect.y + selectAllRect.height);
    }
}

