/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameMatcher
extends AbstractComponentMatcher {
    private final String name;
    private final Class<? extends Component> type;

    public NameMatcher(String name) {
        this(name, false);
    }

    public NameMatcher(String name, boolean requireShowing) {
        this(name, Component.class, requireShowing);
    }

    public NameMatcher(String name, Class<? extends Component> type) {
        this(name, type, false);
    }

    public NameMatcher(String name, Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        if (name == null) {
            throw new NullPointerException("The name of the component to find should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the component to find should not be empty");
        }
        if (type == null) {
            throw new NullPointerException("The type of component to find should not be null");
        }
        this.name = name;
        this.type = type;
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(Component c) {
        return Objects.areEqual(this.name, c.getName()) && this.type.isInstance(c) && this.requireShowingMatches(c);
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[", "name=", Strings.quote(this.name), ", ", "type=", this.type.getName(), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]");
    }
}

