/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

@TransitionAware
public class TransitionAwareResizableIcon
implements ResizableIcon {
    protected int width;
    protected int height;
    private JComponent comp;
    private StateTransitionTrackerDelegate stateTransitionTrackerDelegate;
    private Delegate delegate;
    private LazyResettableHashMap<Icon> iconMap;

    public TransitionAwareResizableIcon(AbstractCommandButton button, StateTransitionTrackerDelegate stateTransitionTrackerDelegate, Delegate delegate, Dimension initialDim) {
        this.comp = button;
        this.stateTransitionTrackerDelegate = stateTransitionTrackerDelegate;
        this.delegate = delegate;
        this.iconMap = new LazyResettableHashMap("TransitionAwareResizableIcon");
        this.width = initialDim.width;
        this.height = initialDim.height;
    }

    private Icon getIconToPaint() {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionTrackerDelegate.getStateTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.comp, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.comp, (ComponentState)currState);
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{baseScheme.getDisplayName(), Float.valueOf(baseAlpha), this.width, this.height});
        Icon layerBase = (Icon)this.iconMap.get(keyBase);
        if (layerBase == null) {
            Icon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme, this.width, this.height);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                this.iconMap.put(keyBase, (Object)layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage((int)baseFullOpacity.getIconWidth(), (int)baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon(this.comp, g2base, 0, 0);
                g2base.dispose();
                layerBase = new ImageIcon(baseImage);
                this.iconMap.put(keyBase, (Object)layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)layerBase.getIconWidth(), (int)layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon(this.comp, g2d, 0, 0);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || !((stateContribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.comp, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.MARK, (ComponentState)activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.comp, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{scheme.getDisplayName(), Float.valueOf(alpha), this.width, this.height});
            Icon layer = (Icon)this.iconMap.get(key);
            if (layer == null) {
                Icon fullOpacity = this.delegate.getColorSchemeIcon(scheme, this.width, this.height);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    this.iconMap.put(key, (Object)layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage((int)fullOpacity.getIconWidth(), (int)fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon(this.comp, g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ImageIcon(image);
                    this.iconMap.put(key, (Object)layer);
                }
            }
            layer.paintIcon(this.comp, g2d, 0, 0);
        }
        g2d.dispose();
        return new ImageIcon(result);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public static interface Delegate {
        public Icon getColorSchemeIcon(SubstanceColorScheme var1, int var2, int var3);
    }

    public static interface StateTransitionTrackerDelegate {
        public StateTransitionTracker getStateTransitionTracker();
    }
}

