/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.ResizableIconUIResource;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.animation.effects.GhostingListener;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.flamingo.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.substance.flamingo.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.substance.flamingo.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

public class SubstanceCommandToggleButtonUI
extends BasicCommandToggleButtonUI
implements ActionPopupTransitionAwareUI {
    protected ButtonBackgroundDelegate backgroundDelegate = new ButtonBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    protected CommandButtonVisualStateTracker substanceVisualStateTracker = new CommandButtonVisualStateTracker();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandToggleButtonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.commandButton.putClientProperty((Object)"substancelaf.buttonShaper", (Object)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder((Border)new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCommandToggleButtonUI.this.substanceModelChangeListener != null) {
                        SubstanceCommandToggleButtonUI.this.substanceModelChangeListener.unregisterListeners();
                    }
                    SubstanceCommandToggleButtonUI.this.substanceModelChangeListener = new GhostingListener((JComponent)SubstanceCommandToggleButtonUI.this.commandButton, (ButtonModel)SubstanceCommandToggleButtonUI.this.commandButton.getActionModel());
                    SubstanceCommandToggleButtonUI.this.substanceModelChangeListener.registerListeners();
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
    }

    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        super.uninstallListeners();
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        JCommandToggleButton jctb = (JCommandToggleButton)this.commandButton;
        ResizableIcon regular = jctb.getIcon();
        if (this.toUseDisabledIcon() && jctb.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = jctb.getDisabledIcon();
        }
        boolean useThemed = SubstanceCoreUtilities.useThemedDefaultIcon((JComponent)this.commandButton);
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        if (regular != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)jctb, (Icon)regular, (Rectangle)iconRect);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jctb, (Graphics)g));
            if (!useThemed) {
                regular.paintIcon((Component)jctb, g2d, iconRect.x, iconRect.y);
            } else {
                CommandButtonBackgroundDelegate.paintThemedCommandButtonIcon(g2d, iconRect, (AbstractCommandButton)jctb, (Icon)regular, (ButtonModel)jctb.getActionModel(), this.substanceVisualStateTracker.getPopupStateTransitionTracker());
            }
            g2d.dispose();
        }
    }

    protected boolean isPaintingBackground() {
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.getActionTransitionTracker().getFacetStrength(ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    protected boolean isPaintingSeparators() {
        return false;
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(FlamingoUtilities.getFont((Component)this.commandButton, (String[])new String[]{"Ribbon.font", "Button.font", "Panel.font"}));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty((Object)"icon.bounds", (Object)this.layoutInfo.iconRect);
        this.commandButton.putClientProperty((Object)"icon", (Object)this.commandButton.getIcon());
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.substanceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        Color fgColor = this.getForegroundColor(modelStateInfo);
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            Color disabledFgColor = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED).getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (modelStateInfo.getCurrModelState().isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)SubstanceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        }
        g2d.dispose();
    }

    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfo, (float)buttonAlpha);
        }
        return fgColor;
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize((JComponent)button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getDisplayState() == CommandButtonDisplayState.MEDIUM && SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, (Component)button) == null) {
            JButton dummy = new JButton(button.getText(), (Icon)button.getIcon());
            return shaper.getPreferredSize((AbstractButton)dummy, superPref);
        }
        return superPref;
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        if (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.commandButton);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.commandButton);
        boolean ignoreSelections = this.commandButton instanceof JCommandToggleMenuButton;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(this.commandButton, (ButtonModel)actionModel, fillPainter, borderPainter, this.commandButton.getWidth(), this.commandButton.getHeight(), this.getActionTransitionTracker(), ignoreSelections);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getActionTransitionTracker().getModelStateInfo();
        Map activeStates = ignoreSelections ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
        boolean isFlat = this.commandButton.isFlat();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
            } else {
                ComponentState actionAreaState = ComponentState.getState((ButtonModel)actionModel, (JComponent)this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.commandButton, (float)extraAlpha, (Graphics)graphics));
            g2d.drawImage((Image)fullAlphaBackground, 0, 0, null);
            g2d.dispose();
        }
    }

    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon((ResizableIcon)new ResizableIconUIResource((ResizableIcon)new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    public boolean isInside(MouseEvent me) {
        return this.getLayoutInfo().actionClickArea.contains(me.getPoint());
    }
}

