/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.flamingo.common.TransitionAwareResizableIcon;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonGalleryUI
extends BasicRibbonGalleryUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonGalleryUI();
    }

    private SubstanceRibbonGalleryUI() {
    }

    protected void paintRibbonGalleryBorder(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.ribbonGallery, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
        SubstanceImageCreator.paintBorder((Component)this.ribbonGallery, (Graphics2D)g2d, (int)this.margin.left, (int)this.margin.top, (int)(this.ribbonGallery.getWidth() - this.margin.left - this.margin.right), (int)(this.ribbonGallery.getHeight() - this.margin.top - this.margin.bottom), (float)SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbonGallery)), (SubstanceColorScheme)borderColorScheme);
        g2d.dispose();
    }

    protected BasicRibbonGalleryUI.ExpandCommandButton createExpandButton() {
        final BasicRibbonGalleryUI.ExpandCommandButton button = super.createExpandButton();
        final int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize) + 3;
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((AbstractCommandButton)button, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)button.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                return SubstanceImageCreator.getDoubleArrowIcon((int)SubstanceSizeUtils.getComponentFontSize((Component)button), (float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (SubstanceColorScheme)scheme);
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon((ResizableIcon)arrowIcon);
        return button;
    }

    protected JCommandButton createScrollDownButton() {
        final JCommandButton button = super.createScrollDownButton();
        final int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((AbstractCommandButton)button, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)button.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                return SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (SubstanceColorScheme)scheme);
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon((ResizableIcon)arrowIcon);
        return button;
    }

    protected JCommandButton createScrollUpButton() {
        final JCommandButton button = super.createScrollUpButton();
        final int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((AbstractCommandButton)button, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)button.getUI()).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                return SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)1, (SubstanceColorScheme)scheme);
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon((ResizableIcon)arrowIcon);
        return button;
    }
}

