/*
 * Decompiled with CFR 0.152.
 */
package tools.docrobot;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.fest.swing.core.BasicRobot;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.timing.Pause;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import test.substance.ribbon.NewCheckRibbon;

public abstract class SkinRobot {
    protected SubstanceSkin skin;
    protected String screenshotFilename;
    protected NewCheckRibbon ribbonFrame;

    public SkinRobot(SubstanceSkin skin, String screenshotFilename) {
        this.skin = skin;
        this.screenshotFilename = screenshotFilename;
    }

    public void run() {
        long start = System.currentTimeMillis();
        Robot robot = BasicRobot.robotWithNewAwtHierarchy();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SubstanceLookAndFeel.setSkin((SubstanceSkin)SkinRobot.this.skin);
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SkinRobot.this.ribbonFrame = new NewCheckRibbon();
                SkinRobot.this.ribbonFrame.configureRibbon();
                SkinRobot.this.ribbonFrame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                SkinRobot.this.ribbonFrame.setPreferredSize(new Dimension(r.width, r.height / 2));
                SkinRobot.this.ribbonFrame.setMinimumSize(new Dimension(100, r.height / 3));
                SkinRobot.this.ribbonFrame.pack();
                SkinRobot.this.ribbonFrame.setLocation(r.x, r.y);
                SkinRobot.this.ribbonFrame.setDefaultCloseOperation(3);
                SkinRobot.this.ribbonFrame.setVisible(true);
            }
        });
        robot.waitForIdle();
        robot.moveMouse(new Point(0, 0));
        robot.waitForIdle();
        Pause.pause(1000L);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SkinRobot.this.makeScreenshot();
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                SkinRobot.this.ribbonFrame.dispose();
            }
        });
        robot.waitForIdle();
        long end = System.currentTimeMillis();
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + " : " + (end - start) + "ms");
    }

    public void makeScreenshot() {
        BufferedImage bi = new BufferedImage(this.ribbonFrame.getWidth(), this.ribbonFrame.getHeight(), 2);
        Graphics g = bi.getGraphics();
        this.ribbonFrame.paint(g);
        BufferedImage finalIm = new BufferedImage(500, 200, 2);
        finalIm.getGraphics().drawImage(bi, 0, 0, null);
        try {
            File output = new File(String.valueOf(this.screenshotFilename) + ".png");
            output.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)finalIm, "png", output);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

