/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Point;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class RenderedRemoteWebElement
extends RemoteWebElement
implements RenderedWebElement,
Locatable {
    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        this.parent.execute("dragElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"x", (Object)moveRightBy, (Object)"y", (Object)moveDownBy));
    }

    public void dragAndDropOn(RenderedWebElement element) {
        Point currentLocation = this.getLocation();
        Point destination = element.getLocation();
        this.dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.getCssValue(propertyName);
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        Response response = this.execute("getElementLocationOnceScrolledIntoView", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.getId()));
        Map mapped = (Map)response.getValue();
        return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
    }

    public Coordinates getCoordinates() {
        return new Coordinates(){

            public Point getLocationOnScreen() {
                return RenderedRemoteWebElement.this.getLocationOnScreenOnceScrolledIntoView();
            }

            public Point getLocationInViewPort() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Point getLocationInDOM() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Object getAuxiliry() {
                return RenderedRemoteWebElement.this.getId();
            }
        };
    }
}

