/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.bind.DatatypeConverter;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.rdf.RdfXmlParser;
import org.semarglproject.rdf.rdfa.DocumentContext;
import org.semarglproject.rdf.rdfa.EvalContext;
import org.semarglproject.rdf.rdfa.VocabManager;
import org.semarglproject.rdf.rdfa.Vocabulary;
import org.semarglproject.ri.MalformedCurieException;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.ri.RIUtils;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.sink.XmlSink;
import org.semarglproject.xml.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class RdfaParser
extends Pipe<TripleSink>
implements XmlSink,
TripleSink,
ProcessorGraphHandler {
    public static final String RDFA_VERSION_PROPERTY = "http://semarglproject.org/rdfa/properties/version";
    public static final String ENABLE_OUTPUT_GRAPH = "http://semarglproject.org/rdfa/properties/enable-output-graph";
    public static final String ENABLE_PROCESSOR_GRAPH = "http://semarglproject.org/rdfa/properties/enable-processor-graph";
    public static final String ENABLE_VOCAB_EXPANSION = "http://semarglproject.org/rdfa/properties/enable-vocab-expansion";
    static final String AUTODETECT_DATE_DATATYPE = "AUTODETECT_DATE_DATATYPE";
    private static final ThreadLocal<VocabManager> VOCAB_MANAGER = new ThreadLocal<VocabManager>(){

        @Override
        protected VocabManager initialValue() {
            return new VocabManager();
        }
    };
    private static final String REVERSED_TRIPLE_FLAG = null;
    private static final String LITERAL_OBJECT_FLAG = null;
    private static final String BODY = "body";
    private static final String HEAD = "head";
    private static final String VERSION = "version";
    private static final String METADATA = "metadata";
    private static final String PLAIN_LITERAL = "";
    private static final String XHTML_DEFAULT_XMLNS = "http://www.w3.org/1999/xhtml";
    private static final String XHTML_VOCAB = "http://www.w3.org/1999/xhtml/vocab#";
    private static final String DATETIME_ATTR = "datetime";
    private static final String TIME_QNAME = "time";
    private static final String VALUE_ATTR = "value";
    private static final String DATA_ATTR = "data";
    private static final String XML_BASE = "xml:base";
    private static final String BASE_IF_HEAD_OR_BODY = "bihob";
    private static final String BASE_IF_ROOT_NODE = "birn";
    private static final String PARENT_OBJECT = "poie";
    private static final String BNODE_IF_TYPEOF = "typeof";
    private Deque<EvalContext> contextStack = null;
    private StringBuilder xmlString = null;
    private List<String> xmlStringPred = null;
    private String xmlStringSubj = null;
    private short defaultRdfaVersion = (short)2;
    private boolean sinkOutputGraph = true;
    private boolean sinkProcessorGraph = true;
    private boolean expandVocab = false;
    private final DocumentContext dh;
    private final Splitter splitter;
    private Locator locator = null;
    private ProcessorGraphHandler processorGraphHandler = null;
    private boolean rdfXmlInline = false;
    private XmlSink rdfXmlParser = null;
    private Map<String, List<String>> patternProps = new HashMap<String, List<String>>();
    private List<String> copyingPairs = new ArrayList<String>();
    private final Map<String, String> overwriteMappings = new HashMap<String, String>();

    private RdfaParser(TripleSink sink) {
        super((DataSink)sink);
        this.contextStack = new LinkedList<EvalContext>();
        this.dh = new DocumentContext(this);
        this.splitter = new Splitter();
    }

    public static XmlSink connect(TripleSink sink) {
        return new RdfaParser(sink);
    }

    public void startDocument() {
        EvalContext initialContext = EvalContext.createInitialContext(this.dh);
        initialContext.iriMappings.put(PLAIN_LITERAL, XHTML_VOCAB);
        this.contextStack.push(initialContext);
        this.xmlString = null;
        this.xmlStringPred = null;
        this.xmlStringSubj = null;
        this.rdfXmlInline = false;
        this.rdfXmlParser = null;
    }

    public void endDocument() throws SAXException {
        if (this.sinkOutputGraph) {
            Iterator<String> iterator = this.copyingPairs.iterator();
            while (iterator.hasNext()) {
                String subj = iterator.next();
                String pattern = iterator.next();
                if (!this.patternProps.containsKey(pattern)) continue;
                this.copyProps(subj, this.patternProps.get(pattern));
            }
            iterator = this.copyingPairs.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                String pattern = iterator.next();
                this.patternProps.remove(pattern);
            }
            for (String pattern : this.patternProps.keySet()) {
                this.addNonLiteralInternal(pattern, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/ns/rdfa#Pattern");
                this.copyProps(pattern, this.patternProps.get(pattern));
            }
        }
        this.dh.clear(this.defaultRdfaVersion);
        this.contextStack.clear();
        this.patternProps.clear();
        this.copyingPairs.clear();
    }

    public void startElement(String nsUri, String localName, String qName, Attributes attrs) throws SAXException {
        String lang;
        if (this.rdfXmlInline) {
            this.rdfXmlParser.startElement(nsUri, localName, qName, attrs);
            return;
        }
        if (this.dh.documentFormat == 4 && localName.equals(METADATA)) {
            if (this.rdfXmlParser == null) {
                this.rdfXmlParser = RdfXmlParser.connect((TripleSink)this);
                this.rdfXmlParser.setBaseUri(this.dh.base);
                this.rdfXmlParser.startDocument();
            }
            this.rdfXmlInline = true;
            return;
        }
        if (this.contextStack.size() < 4) {
            String oldBase = this.dh.base;
            this.dh.detectFormat(localName, qName, attrs.getValue(VERSION));
            this.dh.detectBase(qName, attrs.getValue(XML_BASE), attrs.getValue("href"));
            if (!this.dh.base.equals(oldBase)) {
                for (EvalContext ctx : this.contextStack) {
                    ctx.updateBase(oldBase, this.dh.base);
                }
            }
        }
        EvalContext parent = this.contextStack.peek();
        if (parent.parsingLiteral) {
            this.xmlString.append(XmlUtils.serializeOpenTag((String)nsUri, (String)qName, parent.iriMappings, (Attributes)attrs, (boolean)false));
        }
        if (this.dh.rdfaVersion > 1 && attrs.getValue("prefix") != null) {
            Iterator iterator = this.splitter.split(attrs.getValue("prefix"));
            while (iterator.hasNext()) {
                String prefix = (String)iterator.next();
                int prefixLength = prefix.length();
                if (prefixLength < 2 || prefix.charAt(prefixLength - 1) != ':' || !iterator.hasNext()) continue;
                String uri = (String)iterator.next();
                this.startPrefixMapping(prefix.substring(0, prefixLength - 1), uri);
            }
        }
        if ((lang = attrs.getValue("xml:lang")) == null) {
            lang = attrs.getValue("lang");
        }
        EvalContext current = parent.initChildContext(attrs.getValue("profile"), attrs.getValue("vocab"), lang, this.overwriteMappings);
        this.overwriteMappings.clear();
        boolean skipTerms = this.dh.rdfaVersion > 1 && attrs.getValue("property") != null && (this.dh.documentFormat == 1 || this.dh.documentFormat == 2);
        List<String> rels = this.convertRelRevToList(attrs.getValue("rel"), skipTerms);
        List<String> revs = this.convertRelRevToList(attrs.getValue("rev"), skipTerms);
        boolean noRelsAndRevs = rels == null && revs == null;
        boolean skipElement = this.findSubjectAndObject(qName, attrs, noRelsAndRevs, current, parent);
        if (this.dh.rdfaVersion > 1 && current.subject != null && (!current.subject.equals(parent.object) || parent.subject != null && !parent.subject.equals(parent.object))) {
            current.listMapping = new HashMap<String, List<String>>();
        }
        this.processRels(attrs, rels, current);
        this.processRevs(revs, current);
        if (current.object == null && !noRelsAndRevs) {
            current.object = this.dh.createBnode(false);
        }
        this.processPropertyAttr(qName, attrs, current, parent, noRelsAndRevs);
        if (this.dh.rdfaVersion > 1) {
            this.processRoleAttribute(attrs.getValue("id"), attrs.getValue("role"), current);
        }
        if (!skipElement) {
            this.processIncompleteTriples(current, parent);
        }
        this.pushContext(current, parent, skipElement);
    }

    private List<String> convertRelRevToList(String propertyVal, boolean skipTerms) {
        if (propertyVal == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = this.splitter.split(propertyVal);
        while (this.splitter.hasNext()) {
            String pred = (String)iterator.next();
            if (skipTerms && pred.indexOf(58) == -1) continue;
            result.add(pred);
        }
        if (skipTerms && result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private void processRoleAttribute(String id, String roleVal, EvalContext current) {
        if (roleVal == null) {
            return;
        }
        String subject = id != null ? this.dh.base + '#' + id : this.dh.createBnode(true);
        Iterator iterator = this.splitter.split(roleVal);
        while (this.splitter.hasNext()) {
            try {
                String role = current.resolveRole((String)iterator.next());
                this.addNonLiteral(subject, "http://www.w3.org/1999/xhtml/vocab#role", role);
            }
            catch (MalformedIriException e) {}
        }
    }

    private boolean findSubjectAndObject(String qName, Attributes attrs, boolean noRelAndRev, EvalContext current, EvalContext parent) {
        String newSubject = null;
        try {
            if (this.dh.rdfaVersion > 1) {
                if (noRelAndRev) {
                    if (attrs.getValue("property") != null && attrs.getValue("content") == null && attrs.getValue(VALUE_ATTR) == null && attrs.getValue("datatype") == null) {
                        current.subject = this.coalesce(qName, attrs, parent, current, "about", BASE_IF_ROOT_NODE, PARENT_OBJECT);
                        if (attrs.getValue(BNODE_IF_TYPEOF) != null) {
                            newSubject = current.object = this.coalesce(qName, attrs, parent, current, "about", BASE_IF_ROOT_NODE, "resource", DATA_ATTR, "href", "src", BNODE_IF_TYPEOF);
                        }
                    } else {
                        current.subject = this.coalesce(qName, attrs, parent, current, "about", "resource", DATA_ATTR, "href", "src", BASE_IF_ROOT_NODE, BNODE_IF_TYPEOF, PARENT_OBJECT);
                        if (attrs.getValue(BNODE_IF_TYPEOF) != null) {
                            newSubject = current.subject;
                        }
                    }
                } else {
                    current.object = this.coalesce(qName, attrs, parent, current, "resource", DATA_ATTR, "href", "src");
                    current.subject = this.coalesce(qName, attrs, parent, current, "about", BASE_IF_ROOT_NODE, PARENT_OBJECT);
                    if (attrs.getValue(BNODE_IF_TYPEOF) != null) {
                        if (attrs.getValue("about") != null) {
                            newSubject = current.subject;
                        } else {
                            if (current.object == null) {
                                current.object = this.dh.createBnode(noRelAndRev);
                            }
                            newSubject = current.object;
                        }
                    }
                }
            } else {
                if (noRelAndRev) {
                    current.subject = this.coalesce(qName, attrs, parent, current, "about", "src", "resource", "href", BASE_IF_HEAD_OR_BODY, BNODE_IF_TYPEOF, PARENT_OBJECT);
                } else {
                    current.subject = this.coalesce(qName, attrs, parent, current, "about", "src", BASE_IF_HEAD_OR_BODY, BNODE_IF_TYPEOF, PARENT_OBJECT);
                    current.object = this.coalesce(qName, attrs, parent, current, "resource", "href");
                }
                if (attrs.getValue(BNODE_IF_TYPEOF) != null) {
                    newSubject = current.subject;
                }
            }
        }
        catch (MalformedIriException e) {
            this.warning("http://www.w3.org/ns/rdfa#Warning", e.getMessage());
            this.pushContextNoLiteral(current, parent);
        }
        if (newSubject != null) {
            Iterator iterator = this.splitter.split(attrs.getValue(BNODE_IF_TYPEOF));
            while (this.splitter.hasNext()) {
                try {
                    String iri = current.resolvePredOrDatatype((String)iterator.next());
                    this.addNonLiteral(newSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", iri);
                }
                catch (MalformedIriException e) {}
            }
        }
        return noRelAndRev && attrs.getValue("property") == null && (current.subject == null && parent.object == null || current.subject.equals(parent.object));
    }

    private String coalesce(String tagName, Attributes attrs, EvalContext parent, EvalContext current, String ... attrNames) throws MalformedIriException {
        for (String attr : attrNames) {
            boolean isRoot;
            if (attrs.getValue(attr) != null) {
                if (attr.equals("about") || attr.equals("resource")) {
                    String val = attrs.getValue(attr);
                    if (val.equals("[]")) continue;
                    try {
                        return current.resolveAboutOrResource(val);
                    }
                    catch (MalformedCurieException e) {
                        this.warning("http://www.w3.org/ns/rdfa#UnresolvedCURIE", e.getMessage());
                        return null;
                    }
                }
                if (attr.equals("href") || attr.equals("src") || attr.equals(DATA_ATTR)) {
                    return this.dh.resolveIri(attrs.getValue(attr));
                }
                if (!attr.equals(BNODE_IF_TYPEOF)) continue;
                return this.dh.createBnode(false);
            }
            if (attr.equals(PARENT_OBJECT) && parent.object != null) {
                return parent.object;
            }
            boolean isHeadOrBody = tagName.equals(HEAD) || tagName.equals(BODY);
            boolean bl = isRoot = this.contextStack.size() == 1 || attrs.getValue(BNODE_IF_TYPEOF) != null && isHeadOrBody;
            if ((!isHeadOrBody || !attr.equals(BASE_IF_HEAD_OR_BODY)) && (!isRoot || !attr.equals(BASE_IF_ROOT_NODE))) continue;
            return this.dh.base;
        }
        return null;
    }

    private void processRels(Attributes attrs, List<String> rels, EvalContext current) {
        if (rels != null) {
            boolean inList = this.dh.rdfaVersion > 1 && attrs.getValue("inlist") != null;
            for (String predicate : rels) {
                String iri;
                try {
                    iri = current.resolvePredOrDatatype(predicate);
                }
                catch (MalformedIriException e) {
                    continue;
                }
                if (inList) {
                    List<String> list = current.getMappingForIri(iri);
                    if (current.object != null) {
                        list.add(current.object);
                        continue;
                    }
                    current.incomplTriples.add(list);
                    continue;
                }
                if (current.object != null) {
                    this.addNonLiteral(current.subject, iri, current.object);
                    continue;
                }
                current.incomplTriples.add(iri);
            }
        }
    }

    private void processRevs(List<String> revs, EvalContext current) {
        if (revs != null) {
            for (String predicate : revs) {
                try {
                    String iri = current.resolvePredOrDatatype(predicate);
                    if (current.object != null) {
                        this.addNonLiteral(current.object, iri, current.subject);
                        continue;
                    }
                    current.incomplTriples.add(REVERSED_TRIPLE_FLAG);
                    current.incomplTriples.add(iri);
                }
                catch (MalformedIriException e) {}
            }
        }
    }

    private void processPropertyAttr(String qName, Attributes attrs, EvalContext current, EvalContext parent, boolean noRelsAndRevs) {
        if (attrs.getValue("property") == null) {
            current.parsingLiteral = false;
            return;
        }
        this.parseLiteralObject(qName, attrs, current, parent, noRelsAndRevs);
        boolean bl = current.parsingLiteral = current.objectLitDt == "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
        if (current.properties == null) {
            current.objectLitDt = null;
            current.parsingLiteral = false;
        }
    }

    private void parseLiteralObject(String qName, Attributes attrs, EvalContext current, EvalContext parent, boolean noRelsAndRevs) {
        String content = this.parseContent(attrs);
        String langOrDt = this.parseDatatype(qName, attrs, current);
        if (langOrDt != null && !"http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(langOrDt)) {
            if (content != null) {
                langOrDt = this.resolveLangOrDt(content, langOrDt, current);
            } else {
                current.objectLitDt = langOrDt;
                langOrDt = null;
            }
        } else if (content != null) {
            langOrDt = current.lang;
        } else if (langOrDt == null && this.dh.rdfaVersion > 1) {
            if (attrs.getValue("content") == null && attrs.getValue(VALUE_ATTR) == null && noRelsAndRevs) {
                try {
                    langOrDt = this.coalesce(qName, attrs, parent, current, "resource", DATA_ATTR, "href", "src");
                }
                catch (MalformedIriException e) {
                    this.warning("http://www.w3.org/ns/rdfa#Warning", e.getMessage());
                    this.pushContextNoLiteral(current, parent);
                }
            }
            if (langOrDt == null) {
                if (attrs.getValue("about") == null && attrs.getValue(BNODE_IF_TYPEOF) != null) {
                    langOrDt = current.object;
                    if (current.object == null) {
                        current.objectLitDt = PLAIN_LITERAL;
                    }
                } else {
                    current.objectLitDt = PLAIN_LITERAL;
                }
            }
        } else {
            current.objectLitDt = langOrDt == null || langOrDt.length() > 0 ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral" : PLAIN_LITERAL;
            langOrDt = null;
        }
        boolean inList = attrs.getValue("inlist") != null;
        this.processPropertyPredicate(attrs, content, langOrDt, current, inList);
    }

    private String parseContent(Attributes attrs) {
        String content = attrs.getValue("content");
        if (content == null && this.dh.documentFormat == 2) {
            if (attrs.getValue(VALUE_ATTR) != null) {
                content = attrs.getValue(VALUE_ATTR);
            }
            if (attrs.getValue(DATETIME_ATTR) != null) {
                content = attrs.getValue(DATETIME_ATTR);
            }
        }
        return content;
    }

    private String parseDatatype(String qName, Attributes attrs, EvalContext current) {
        String datatype = attrs.getValue("datatype");
        if (this.dh.documentFormat == 2) {
            if (attrs.getValue(DATETIME_ATTR) != null) {
                if (datatype == null) {
                    datatype = AUTODETECT_DATE_DATATYPE;
                }
            } else if (qName.equals(TIME_QNAME) && datatype == null) {
                datatype = AUTODETECT_DATE_DATATYPE;
            }
        }
        try {
            if (datatype != null && datatype.length() > 0) {
                datatype = current.resolvePredOrDatatype(datatype);
            }
        }
        catch (MalformedIriException e) {
            datatype = null;
        }
        return datatype;
    }

    private void processPropertyPredicate(Attributes attrs, String content, String langOrUri, EvalContext current, boolean inList) {
        Iterator iterator = this.splitter.split(attrs.getValue("property"));
        while (this.splitter.hasNext()) {
            String iri;
            try {
                iri = current.resolvePredOrDatatype((String)iterator.next());
            }
            catch (MalformedIriException e) {
                continue;
            }
            if (content != null || langOrUri != null) {
                if (this.dh.rdfaVersion > 1 && inList) {
                    List<String> list = current.getMappingForIri(iri);
                    if (content != null) {
                        list.add(LITERAL_OBJECT_FLAG);
                        list.add(content);
                        list.add(langOrUri);
                        continue;
                    }
                    list.add(langOrUri);
                    continue;
                }
                if (content != null) {
                    this.addLiteralTriple(current.subject, iri, content, langOrUri);
                    continue;
                }
                this.addNonLiteral(current.subject, iri, langOrUri);
                continue;
            }
            if (current.properties == null) {
                current.properties = new ArrayList<String>();
                if (this.dh.rdfaVersion > 1 && inList) {
                    current.properties.add("inlist");
                }
                current.properties.add(iri);
                continue;
            }
            current.properties.add(iri);
        }
    }

    private String resolveLangOrDt(String content, String dt, EvalContext current) {
        if (dt == null) {
            return current.lang;
        }
        if (dt.equals(AUTODETECT_DATE_DATATYPE)) {
            try {
                if (content.matches("-?P\\d+Y\\d+M\\d+DT\\d+H\\d+M\\d+(\\.\\d+)?S")) {
                    return "http://www.w3.org/2001/XMLSchema#duration";
                }
                if (content.indexOf(58) != -1) {
                    if (content.indexOf(84) != -1) {
                        DatatypeConverter.parseDateTime((String)content);
                        return "http://www.w3.org/2001/XMLSchema#dateTime";
                    }
                    DatatypeConverter.parseTime((String)content);
                    return "http://www.w3.org/2001/XMLSchema#time";
                }
                if (content.matches("-?\\d{4,}")) {
                    return "http://www.w3.org/2001/XMLSchema#gYear";
                }
                if (content.matches("-?\\d{4,}-(0[1-9]|1[0-2])")) {
                    return "http://www.w3.org/2001/XMLSchema#gYearMonth";
                }
                DatatypeConverter.parseDate((String)content);
                return "http://www.w3.org/2001/XMLSchema#date";
            }
            catch (IllegalArgumentException e) {
                return current.lang;
            }
        }
        if (dt.indexOf(58) == -1) {
            return current.lang;
        }
        return dt;
    }

    private void processIncompleteTriples(EvalContext current, EvalContext parent) {
        if (current.subject == null) {
            return;
        }
        String subject = parent.subject;
        Iterator<Object> iti = parent.incomplTriples.iterator();
        while (iti.hasNext()) {
            Object predicateOrList = iti.next();
            if (predicateOrList == REVERSED_TRIPLE_FLAG) {
                this.addNonLiteral(current.subject, (String)iti.next(), subject);
                continue;
            }
            if (predicateOrList instanceof String) {
                this.addNonLiteral(subject, (String)predicateOrList, current.subject);
                continue;
            }
            Collection list = (Collection)predicateOrList;
            list.add(current.subject);
        }
    }

    private void pushContext(EvalContext current, EvalContext parent, boolean skipElement) {
        if (current.parsingLiteral) {
            this.xmlString = new StringBuilder();
            this.xmlStringPred = current.properties;
            String string = this.xmlStringSubj = current.subject == null ? parent.subject : current.subject;
        }
        if (current.parsingLiteral || skipElement) {
            current.subject = parent.subject;
            current.object = parent.object;
            current.incomplTriples = parent.incomplTriples;
            current.objectLit = null;
            current.objectLitDt = parent.objectLitDt;
            if (current.objectLitDt != null) {
                current.objectLit = PLAIN_LITERAL;
            }
            current.properties = null;
            this.contextStack.push(current);
        } else {
            this.pushContextNoLiteral(current, parent);
        }
    }

    private void pushContextNoLiteral(EvalContext current, EvalContext parent) {
        if (current.subject == null) {
            current.subject = parent.subject;
        }
        if (current.object == null) {
            current.object = current.subject;
        }
        if (current.objectLitDt != null || parent.objectLitDt != null) {
            current.objectLit = PLAIN_LITERAL;
        }
        this.contextStack.push(current);
    }

    public void endElement(String nsUri, String localName, String qName) throws SAXException {
        if (this.rdfXmlInline) {
            if (this.dh.documentFormat == 4 && localName.equals(METADATA)) {
                this.rdfXmlParser.endDocument();
                this.rdfXmlParser = null;
                this.rdfXmlInline = false;
            } else {
                this.rdfXmlParser.endElement(nsUri, localName, qName);
            }
            return;
        }
        EvalContext current = this.contextStack.pop();
        this.processXmlString(current);
        if (this.xmlString != null) {
            this.xmlString.append("</").append(qName).append('>');
        }
        if (this.contextStack.isEmpty()) {
            return;
        }
        EvalContext parent = this.contextStack.peek();
        this.processContent(current, parent);
        if (parent.listMapping != current.listMapping) {
            this.processListMappings(current);
        }
    }

    private void processXmlString(EvalContext current) {
        block4: {
            if (!current.parsingLiteral || this.xmlString == null) break block4;
            String content = this.xmlString.toString();
            this.xmlString = null;
            if (this.dh.rdfaVersion == 1 && content.indexOf(60) == -1) {
                for (String pred : this.xmlStringPred) {
                    this.addPlainLiteral(this.xmlStringSubj, pred, content, current.lang);
                }
            } else {
                for (String pred : this.xmlStringPred) {
                    this.addTypedLiteral(this.xmlStringSubj, pred, content, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
                }
            }
        }
    }

    private void processContent(EvalContext current, EvalContext parent) {
        String content = current.objectLit;
        if (content == null) {
            return;
        }
        if (!parent.parsingLiteral && parent.objectLit != null) {
            parent.objectLit = parent.objectLit + content;
        }
        if (current.properties == null) {
            return;
        }
        String dt = current.objectLitDt;
        boolean inlist = "inlist".equals(current.properties.get(0));
        if (inlist) {
            String langOrDt = this.resolveLangOrDt(content, dt, current);
            current.properties.remove(0);
            for (String predIri : current.properties) {
                List<String> mappingForIri = current.getMappingForIri(predIri);
                mappingForIri.add(LITERAL_OBJECT_FLAG);
                mappingForIri.add(content);
                mappingForIri.add(langOrDt);
            }
        } else {
            for (String predIri : current.properties) {
                dt = this.resolveLangOrDt(content, dt, current);
                this.addLiteralTriple(current.subject, predIri, content, dt);
            }
        }
    }

    private void processListMappings(EvalContext current) {
        Map<String, List<String>> list = current.listMapping;
        for (String pred : list.keySet()) {
            String prev = null;
            String start = null;
            Iterator<String> iterator = list.get(pred).iterator();
            while (iterator.hasNext()) {
                String res = iterator.next();
                String child = this.dh.createBnode(false);
                if (res == LITERAL_OBJECT_FLAG) {
                    String content = iterator.next();
                    String langOrDt = iterator.next();
                    this.addLiteralTriple(child, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", content, langOrDt);
                } else {
                    this.addNonLiteral(child, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", res);
                }
                if (prev == null) {
                    start = child;
                } else {
                    this.addNonLiteral(prev, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", child);
                }
                prev = child;
            }
            if (start == null) {
                this.addNonLiteral(current.subject, pred, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                continue;
            }
            this.addNonLiteral(prev, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            this.addNonLiteral(current.subject, pred, start);
        }
        list.clear();
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.rdfXmlInline) {
            this.rdfXmlParser.characters(buffer, start, length);
            return;
        }
        EvalContext parent = this.contextStack.peek();
        if (this.xmlString != null) {
            this.xmlString.append(buffer, start, length);
        }
        if (parent.objectLit != null) {
            parent.addContent(String.copyValueOf(buffer, start, length));
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.rdfXmlInline) {
            this.rdfXmlParser.ignorableWhitespace(ch, start, length);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dh.processDtd(name, publicId, systemId);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.rdfXmlInline) {
            this.rdfXmlParser.startPrefixMapping(prefix, uri);
            return;
        }
        if (prefix.length() == 0 && XHTML_DEFAULT_XMLNS.equalsIgnoreCase(uri)) {
            this.overwriteMappings.put(prefix, XHTML_VOCAB);
        } else {
            try {
                this.overwriteMappings.put(prefix, RIUtils.resolveIri((String)this.dh.originUri, (String)uri));
            }
            catch (MalformedIriException malformedIriException) {
                // empty catch block
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.rdfXmlInline) {
            this.rdfXmlParser.endPrefixMapping(prefix);
        }
    }

    public boolean setPropertyInternal(String key, Object value) {
        if (ENABLE_OUTPUT_GRAPH.equals(key) && value instanceof Boolean) {
            this.sinkOutputGraph = (Boolean)value;
        } else if (ENABLE_PROCESSOR_GRAPH.equals(key) && value instanceof Boolean) {
            this.sinkProcessorGraph = (Boolean)value;
        } else if (ENABLE_VOCAB_EXPANSION.equals(key) && value instanceof Boolean) {
            this.expandVocab = (Boolean)value;
        } else if (this.sinkProcessorGraph || this.expandVocab) {
            this.defaultRdfaVersion = (short)2;
        } else if (RDFA_VERSION_PROPERTY.equals(key) && value instanceof Integer) {
            int rdfaVersion = (Integer)value;
            if (rdfaVersion < 1 || rdfaVersion > 2) {
                throw new IllegalArgumentException("Unsupported RDFa version");
            }
            this.defaultRdfaVersion = (short)rdfaVersion;
        } else {
            if ("http://semarglproject.org/core/properties/processor-graph-handler".equals(key) && value instanceof ProcessorGraphHandler) {
                this.processorGraphHandler = (ProcessorGraphHandler)value;
                return false;
            }
            return false;
        }
        return true;
    }

    public void setBaseUri(String baseUri) {
        this.dh.setBaseUri(baseUri);
    }

    Vocabulary loadVocabulary(String vocabUrl) {
        if (this.sinkOutputGraph) {
            ((TripleSink)this.sink).addNonLiteral(this.dh.base, "http://www.w3.org/ns/rdfa#usesVocabulary", vocabUrl);
        }
        return VOCAB_MANAGER.get().findVocab(vocabUrl, this.expandVocab);
    }

    public void info(String infoClass, String message) {
        this.addProcessorGraphRecord(infoClass, message);
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.info(infoClass, message);
        }
    }

    public void warning(String warningClass, String message) {
        this.addProcessorGraphRecord(warningClass, message);
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.warning(warningClass, message);
        }
    }

    public void error(String errorClass, String message) {
        this.addProcessorGraphRecord(errorClass, message);
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.error(errorClass, message);
        }
    }

    private void addProcessorGraphRecord(String recordClass, String recordContext) {
        if (this.dh.rdfaVersion > 1 && this.sinkProcessorGraph) {
            String errorNode = this.dh.createBnode(true);
            String location = PLAIN_LITERAL;
            if (this.locator != null) {
                location = " at " + this.locator.getLineNumber() + ':' + this.locator.getColumnNumber();
            }
            ((TripleSink)this.sink).addNonLiteral(errorNode, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", recordClass);
            ((TripleSink)this.sink).addPlainLiteral(errorNode, "http://www.w3.org/ns/rdfa#context", recordContext + location, null);
        }
    }

    public ParseException processException(SAXException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ParseException) {
            this.error("http://www.w3.org/ns/rdfa#Error", cause.getMessage());
            return (ParseException)cause;
        }
        this.error("http://www.w3.org/ns/rdfa#Error", e.getMessage());
        return new ParseException((Throwable)e);
    }

    private void copyProps(String subj, List<String> props) {
        Iterator<String> iterator = props.iterator();
        while (iterator.hasNext()) {
            String type = iterator.next();
            if (type == null) {
                this.addNonLiteralInternal(subj, iterator.next(), iterator.next());
                continue;
            }
            if (type.isEmpty()) {
                this.addPlainLiteralInternal(subj, iterator.next(), iterator.next(), iterator.next());
                continue;
            }
            this.addTypedLiteralInternal(subj, iterator.next(), iterator.next(), type);
        }
    }

    private void addLiteralTriple(String subject, String pred, String content, String langOrDt) {
        if (langOrDt == null || langOrDt.length() < 6 || langOrDt.indexOf(58) == -1) {
            this.addPlainLiteral(subject, pred, content, langOrDt);
        } else {
            this.addTypedLiteral(subject, pred, content, langOrDt);
        }
    }

    public void addNonLiteral(String subj, String pred, String obj) {
        if (!this.sinkOutputGraph) {
            return;
        }
        if (obj.equals("http://www.w3.org/ns/rdfa#Pattern")) {
            if (!this.patternProps.containsKey(subj)) {
                this.patternProps.put(subj, new ArrayList());
            }
            return;
        }
        if (pred.equals("http://www.w3.org/ns/rdfa#copy")) {
            if (this.patternProps.containsKey(obj)) {
                this.copyProps(subj, this.patternProps.get(obj));
            } else {
                this.copyingPairs.add(subj);
                this.copyingPairs.add(obj);
            }
            return;
        }
        if (this.patternProps.containsKey(subj)) {
            List<String> props = this.patternProps.get(subj);
            props.add(null);
            props.add(pred);
            props.add(obj);
            return;
        }
        this.addNonLiteralInternal(subj, pred, obj);
    }

    private void addNonLiteralInternal(String subj, String pred, String obj) {
        if (!this.expandVocab) {
            ((TripleSink)this.sink).addNonLiteral(subj, pred, obj);
            return;
        }
        this.addNonLiteralWithObjExpansion(subj, pred, obj);
        for (String predSynonym : this.contextStack.peek().expand(pred)) {
            this.addNonLiteralWithObjExpansion(subj, predSynonym, obj);
        }
    }

    private void addNonLiteralWithObjExpansion(String subj, String pred, String obj) {
        if (obj.startsWith("_:")) {
            ((TripleSink)this.sink).addNonLiteral(subj, pred, obj);
            return;
        }
        ((TripleSink)this.sink).addNonLiteral(subj, pred, obj);
        for (String objSynonym : this.contextStack.peek().expand(obj)) {
            ((TripleSink)this.sink).addNonLiteral(subj, pred, objSynonym);
        }
    }

    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        if (!this.sinkOutputGraph) {
            return;
        }
        if (this.patternProps.containsKey(subj)) {
            List<String> props = this.patternProps.get(subj);
            props.add(PLAIN_LITERAL);
            props.add(pred);
            props.add(content);
            props.add(lang);
            return;
        }
        this.addPlainLiteralInternal(subj, pred, content, lang);
    }

    private void addPlainLiteralInternal(String subj, String pred, String content, String lang) {
        ((TripleSink)this.sink).addPlainLiteral(subj, pred, content, lang);
        for (String predSynonym : this.contextStack.peek().expand(pred)) {
            ((TripleSink)this.sink).addPlainLiteral(subj, predSynonym, content, lang);
        }
    }

    public void addTypedLiteral(String subj, String pred, String content, String type) {
        if (!this.sinkOutputGraph) {
            return;
        }
        if (this.patternProps.containsKey(subj)) {
            List<String> props = this.patternProps.get(subj);
            props.add(type);
            props.add(pred);
            props.add(content);
            return;
        }
        this.addTypedLiteralInternal(subj, pred, content, type);
    }

    private void addTypedLiteralInternal(String subj, String pred, String content, String type) {
        ((TripleSink)this.sink).addTypedLiteral(subj, pred, content, type);
        for (String predSynonym : this.contextStack.peek().expand(pred)) {
            ((TripleSink)this.sink).addTypedLiteral(subj, predSynonym, content, type);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startEntity(String s) throws SAXException {
    }

    public void endEntity(String s) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] chars, int i, int i1) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    private static final class Splitter
    implements Iterator<String> {
        private int pos = -1;
        private int length = -1;
        private String string = null;

        private Splitter() {
        }

        private Iterator<String> split(String string) {
            this.string = string;
            this.length = string.length();
            this.pos = 0;
            while (this.pos < this.length && XmlUtils.WHITESPACE.get(string.charAt(this.pos))) {
                ++this.pos;
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.length;
        }

        @Override
        public String next() {
            int start = this.pos;
            while (this.pos < this.length && !XmlUtils.WHITESPACE.get(this.string.charAt(this.pos))) {
                ++this.pos;
            }
            if (start == this.pos) {
                throw new NoSuchElementException();
            }
            String result = this.string.substring(start, this.pos);
            while (this.pos < this.length && XmlUtils.WHITESPACE.get(this.string.charAt(this.pos))) {
                ++this.pos;
            }
            if (this.pos == this.length) {
                this.string = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

