/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackCoordinates;
import org.springframework.boot.buildpack.platform.build.BuildpackLayersMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.StreamUtils;

final class ImageBuildpack
implements Buildpack {
    private static final String PREFIX = "docker://";
    private final BuildpackCoordinates coordinates;
    private final ExportedLayers exportedLayers;

    private ImageBuildpack(BuildpackResolverContext context, ImageReference imageReference) {
        ImageReference reference = imageReference.inTaggedOrDigestForm();
        try {
            Image image = context.fetchImage(reference, ImageType.BUILDPACK);
            BuildpackMetadata buildpackMetadata = BuildpackMetadata.fromImage(image);
            this.coordinates = BuildpackCoordinates.fromBuildpackMetadata(buildpackMetadata);
            this.exportedLayers = !this.buildpackExistsInBuilder(context, image.getLayers()) ? new ExportedLayers(context, reference) : null;
        }
        catch (IOException | DockerEngineException ex) {
            throw new IllegalArgumentException("Error pulling buildpack image '" + reference + "'", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean buildpackExistsInBuilder(BuildpackResolverContext context, List<LayerId> imageLayers) {
        BuildpackLayersMetadata.BuildpackLayerDetails buildpackLayerDetails = context.getBuildpackLayersMetadata().getBuildpack(this.coordinates.getId(), this.coordinates.getVersion());
        if (buildpackLayerDetails == null) return false;
        String string = buildpackLayerDetails.getLayerDiffId();
        String layerDiffId = string;
        if (layerDiffId == null) return false;
        if (!imageLayers.stream().map(LayerId::toString).anyMatch(layerDiffId::equals)) return false;
        return true;
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
        if (this.exportedLayers != null) {
            this.exportedLayers.apply(layers);
        }
    }

    static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        boolean unambiguous = reference.hasPrefix(PREFIX);
        try {
            ImageReference imageReference = ImageReference.of(unambiguous ? reference.getSubReference(PREFIX) : reference.toString());
            return new ImageBuildpack(context, imageReference);
        }
        catch (IllegalArgumentException ex) {
            if (unambiguous) {
                throw ex;
            }
            return null;
        }
    }

    private static class ExportedLayers {
        private final List<Path> layerFiles;

        ExportedLayers(BuildpackResolverContext context, ImageReference imageReference) throws IOException {
            ArrayList layerFiles = new ArrayList();
            context.exportImageLayers(imageReference, (name, tarArchive) -> layerFiles.add(this.createLayerFile((TarArchive)tarArchive)));
            this.layerFiles = Collections.unmodifiableList(layerFiles);
        }

        private Path createLayerFile(TarArchive tarArchive) throws IOException {
            Path sourceTarFile = Files.createTempFile("create-builder-scratch-source-", null, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(sourceTarFile, new OpenOption[0]);){
                tarArchive.writeTo(out);
            }
            Path layerFile = Files.createTempFile("create-builder-scratch-", null, new FileAttribute[0]);
            try (TarArchiveOutputStream out = new TarArchiveOutputStream(Files.newOutputStream(layerFile, new OpenOption[0]));
                 TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(sourceTarFile, new OpenOption[0]));){
                out.setLongFileMode(3);
                TarArchiveEntry entry = in.getNextEntry();
                while (entry != null) {
                    out.putArchiveEntry(entry);
                    StreamUtils.copy((InputStream)in, (OutputStream)out);
                    out.closeArchiveEntry();
                    entry = in.getNextEntry();
                }
                out.finish();
            }
            return layerFile;
        }

        void apply(IOConsumer<Layer> layers) throws IOException {
            for (Path path : this.layerFiles) {
                layers.accept(Layer.fromTarArchive(out -> {
                    InputStream in = Files.newInputStream(path, new OpenOption[0]);
                    StreamUtils.copy((InputStream)in, (OutputStream)out);
                }));
                Files.delete(path);
            }
        }
    }
}

