/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.dmr.ModelNode;

public class CommandBuilderTree
extends JTree {
    private CliGuiContext cliGuiCtx;
    private ManagementModelNode currentNode = null;
    private String currentDescription = null;

    public CommandBuilderTree(CliGuiContext cliGuiCtx, TreeModel model) {
        super(model);
        this.cliGuiCtx = cliGuiCtx;
        this.setToolTipText("");
    }

    @Override
    public synchronized String getToolTipText(MouseEvent me) {
        if (this.getRowForLocation(me.getX(), me.getY()) == -1) {
            this.currentNode = null;
            this.currentDescription = null;
            return null;
        }
        TreePath treePath = this.getPathForLocation(me.getX(), me.getY());
        ManagementModelNode node = (ManagementModelNode)treePath.getLastPathComponent();
        if (node == this.currentNode) {
            return this.currentDescription;
        }
        this.currentNode = node;
        this.currentDescription = null;
        try {
            ModelNode readResource = this.cliGuiCtx.getExecutor().doCommand(node.addressPath() + ":read-resource-description");
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)node.getUserObject();
            if (node.isGeneric()) {
                this.currentDescription = "Used for generic operations on " + usrObj.getName() + ", such as 'add'";
            } else if (!node.isLeaf()) {
                this.currentDescription = readResource.get(new String[]{"result", "description"}).asString();
            } else {
                ModelNode description = readResource.get(new String[]{"result", "attributes", usrObj.getName(), "description"});
                if (description.isDefined()) {
                    this.currentDescription = description.asString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.currentDescription;
    }
}

