/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.arguments.ArgumentValueState;
import org.jboss.as.cli.parsing.arguments.ListItemSeparatorState;

public class ListState
extends DefaultParsingState {
    public static final String ID = "LIST";

    public ListState(final ArgumentValueState value) {
        super(ID);
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.getCharacter() != '[') {
                    ctx.enterState(value);
                }
            }
        });
        this.setDefaultHandler(new LineBreakHandler(false, false){

            @Override
            protected void doHandle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(value);
            }
        });
        this.setIgnoreWhitespaces(true);
        this.enterState(',', ListItemSeparatorState.INSTANCE);
        this.leaveState(']');
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                if (ctx.getCharacter() == ',' || ctx.getCharacter() == '}') {
                    return;
                }
                ListState.this.getHandler(ctx.getCharacter()).handle(ctx);
            }
        });
    }
}

