/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.inflow;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.as.ejb3.inflow.MessageEndpointInvocationHandler;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JBossMessageEndpointFactory
implements MessageEndpointFactory {
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);
    private final MessageEndpointService<?> service;
    private final ProxyFactory<Object> factory;
    private final Class<?> endpointClass;

    public JBossMessageEndpointFactory(ClassLoader classLoader, MessageEndpointService<?> service, Class<Object> ejbClass, Class<?> messageListenerInterface) {
        this.service = service;
        ProxyConfiguration configuration = new ProxyConfiguration().setClassLoader(classLoader).setProxyName(ejbClass.getName() + "$$$endpoint" + PROXY_ID.incrementAndGet()).setSuperClass(ejbClass).setProtectionDomain(ejbClass.getProtectionDomain()).addAdditionalInterface(MessageEndpoint.class).addAdditionalInterface(messageListenerInterface);
        this.factory = new ProxyFactory(configuration);
        this.endpointClass = ejbClass;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createEndpoint(xaResource, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        Object delegate = this.service.obtain(timeout, TimeUnit.MILLISECONDS);
        MessageEndpointInvocationHandler handler = new MessageEndpointInvocationHandler(this.service, delegate, xaResource);
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.factory.getClassLoader());
            if (System.getSecurityManager() == null) {
                MessageEndpoint messageEndpoint = this.createEndpoint(this.factory, handler);
                return messageEndpoint;
            }
            MessageEndpoint messageEndpoint = AccessController.doPrivileged(() -> this.createEndpoint(this.factory, handler));
            return messageEndpoint;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.service.isDeliveryTransacted(method);
    }

    public String getActivationName() {
        return this.service.getActivationName();
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    private MessageEndpoint createEndpoint(ProxyFactory<Object> factory, MessageEndpointInvocationHandler handler) {
        try {
            return (MessageEndpoint)factory.newInstance((InvocationHandler)handler);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

