/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner;
import com.arjuna.ats.internal.jta.recovery.arjunacore.CommitMarkableResourceRecordRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.SubordinateAtomicActionRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.jts.JCAServerTransactionRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.jts.XARecoveryModule;
import com.arjuna.ats.internal.jts.orbspecific.recovery.RecoveryEnablement;
import com.arjuna.ats.internal.jts.recovery.contact.ExpiredContactScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredServerScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredToplevelScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule;
import com.arjuna.ats.internal.jts.recovery.transactions.TopLevelTransactionRecoveryModule;
import com.arjuna.ats.internal.txoj.recovery.TORecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.suspend.RecoverySuspendController;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;

public class ArjunaRecoveryManagerService
implements Service<RecoveryManagerService> {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER;
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> recoveryBindingInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> statusBindingInjector = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private RecoveryManagerService recoveryManagerService;
    private RecoverySuspendController recoverySuspendController;
    private boolean recoveryListener;
    private final boolean jts;
    private InjectedValue<SocketBindingManager> bindingManager = new InjectedValue();

    public ArjunaRecoveryManagerService(boolean recoveryListener, boolean jts) {
        this.recoveryListener = recoveryListener;
        this.jts = jts;
    }

    public synchronized void start(StartContext context) throws StartException {
        ArrayList<String> expiryScanners;
        RecoveryEnvironmentBean recoveryEnvironmentBean = recoveryPropertyManager.getRecoveryEnvironmentBean();
        SocketBinding recoveryBinding = (SocketBinding)this.recoveryBindingInjector.getValue();
        recoveryEnvironmentBean.setRecoveryInetAddress(recoveryBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setRecoveryPort(recoveryBinding.getSocketAddress().getPort());
        SocketBinding statusBinding = (SocketBinding)this.statusBindingInjector.getValue();
        recoveryEnvironmentBean.setTransactionStatusManagerInetAddress(statusBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setTransactionStatusManagerPort(statusBinding.getSocketAddress().getPort());
        recoveryEnvironmentBean.setRecoveryListener(this.recoveryListener);
        if (this.recoveryListener) {
            ManagedBinding binding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)recoveryBinding);
            ((SocketBindingManager)this.bindingManager.getValue()).getNamedRegistry().registerBinding(binding);
        }
        ArrayList<String> recoveryExtensions = new ArrayList<String>();
        recoveryExtensions.add(CommitMarkableResourceRecordRecoveryModule.class.getName());
        recoveryExtensions.add(AtomicActionRecoveryModule.class.getName());
        recoveryExtensions.add(TORecoveryModule.class.getName());
        recoveryExtensions.add(SubordinateAtomicActionRecoveryModule.class.getName());
        if (System.getProperty("RecoveryEnvironmentBean.expiryScannerClassNames") != null) {
            expiryScanners = recoveryEnvironmentBean.getExpiryScannerClassNames();
        } else {
            expiryScanners = new ArrayList<String>();
            expiryScanners.add(ExpiredTransactionStatusManagerScanner.class.getName());
        }
        if (!this.jts) {
            recoveryExtensions.add(com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivators(null);
            RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
            try {
                recoveryManagerService.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Recovery");
            }
            recoveryManagerService.start();
            this.recoveryManagerService = recoveryManagerService;
        } else {
            ORB orb = (ORB)this.orbInjector.getValue();
            new PostInitLoader(PostInitLoader.generateORBPropertyName((String)"com.arjuna.orbportability.orb"), (Object)orb);
            recoveryExtensions.add(TopLevelTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(ServerTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(JCAServerTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(XARecoveryModule.class.getName());
            expiryScanners.add(ExpiredContactScanner.class.getName());
            expiryScanners.add(ExpiredToplevelScanner.class.getName());
            expiryScanners.add(ExpiredServerScanner.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivatorClassNames(Collections.singletonList(RecoveryEnablement.class.getName()));
            try {
                com.arjuna.ats.jbossatx.jts.RecoveryManagerService recoveryManagerService = new com.arjuna.ats.jbossatx.jts.RecoveryManagerService(orb);
                recoveryManagerService.create();
                recoveryManagerService.start();
                this.recoveryManagerService = recoveryManagerService;
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Recovery");
            }
        }
        this.recoverySuspendController = new RecoverySuspendController(this.recoveryManagerService);
        ((SuspendController)this.suspendControllerInjector.getValue()).registerActivity((ServerActivity)this.recoverySuspendController);
    }

    public synchronized void stop(StopContext context) {
        ((SuspendController)this.suspendControllerInjector.getValue()).unRegisterActivity((ServerActivity)this.recoverySuspendController);
        try {
            this.recoveryManagerService.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recoveryManagerService.destroy();
        this.recoveryManagerService = null;
        this.recoverySuspendController = null;
    }

    public synchronized RecoveryManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.recoveryManagerService;
    }

    public Injector<ORB> getOrbInjector() {
        return this.orbInjector;
    }

    public Injector<SocketBinding> getRecoveryBindingInjector() {
        return this.recoveryBindingInjector;
    }

    public Injector<SocketBinding> getStatusBindingInjector() {
        return this.statusBindingInjector;
    }

    public Injector<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    public Injector<SocketBindingManager> getBindingManager() {
        return this.bindingManager;
    }
}

