/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.Util;

public class WrappedByteArray
implements WrappedBytes {
    private final byte[] bytes;
    private transient int hashCode;
    private transient boolean initializedHashCode;

    public WrappedByteArray(byte[] bytes) {
        this.bytes = bytes;
    }

    public WrappedByteArray(byte[] bytes, int hashCode) {
        this.bytes = bytes;
        assert (hashCode == Arrays.hashCode(bytes)) : "HashCode " + hashCode + " doesn't match " + Arrays.hashCode(bytes);
        this.hashCode = hashCode;
        this.initializedHashCode = true;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int backArrayOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public byte getByte(int offset) {
        return this.bytes[offset];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Class<?> oClass = o.getClass();
        if (this.getClass() != oClass) {
            return WrappedBytes.class.isAssignableFrom(oClass) && this.equalsWrappedBytes((WrappedBytes)o);
        }
        WrappedByteArray that = (WrappedByteArray)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    @Override
    public boolean equalsWrappedBytes(WrappedBytes other) {
        int length = this.getLength();
        if (other.getLength() != length) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.getByte(i) == other.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.initializedHashCode) {
            this.hashCode = Arrays.hashCode(this.bytes);
            this.initializedHashCode = true;
        }
        return this.hashCode;
    }

    public String toString() {
        return "WrappedByteArray{bytes=" + Util.printArray(this.bytes) + ", hashCode=" + this.hashCode + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<WrappedByteArray> {
        @Override
        public Set<Class<? extends WrappedByteArray>> getTypeClasses() {
            return Collections.singleton(WrappedByteArray.class);
        }

        @Override
        public Integer getId() {
            return 21;
        }

        @Override
        public void writeObject(ObjectOutput output, WrappedByteArray object) throws IOException {
            MarshallUtil.marshallByteArray(object.bytes, output);
            if (object.initializedHashCode) {
                output.writeBoolean(true);
                output.writeInt(object.hashCode);
            } else {
                output.writeBoolean(false);
            }
        }

        @Override
        public WrappedByteArray readObject(ObjectInput input) throws IOException {
            byte[] bytes = MarshallUtil.unmarshallByteArray(input);
            boolean hasHashCode = input.readBoolean();
            if (hasHashCode) {
                return new WrappedByteArray(bytes, input.readInt());
            }
            return new WrappedByteArray(bytes);
        }
    }
}

